// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema for details of a delivery attempt.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsSmsDeliveryAttemptProperties implements JsonSerializable<AcsSmsDeliveryAttemptProperties> {

    /*
     * TimeStamp when delivery was attempted
     */
    @Generated
    private OffsetDateTime timestamp;

    /*
     * Number of segments that were successfully delivered
     */
    @Generated
    private Integer segmentsSucceeded;

    /*
     * Number of segments whose delivery failed
     */
    @Generated
    private Integer segmentsFailed;

    /**
     * Creates an instance of AcsSmsDeliveryAttemptProperties class.
     */
    @Generated
    public AcsSmsDeliveryAttemptProperties() {
    }

    /**
     * Get the timestamp property: TimeStamp when delivery was attempted.
     *
     * @return the timestamp value.
     */
    @Generated
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: TimeStamp when delivery was attempted.
     *
     * @param timestamp the timestamp value to set.
     * @return the AcsSmsDeliveryAttemptProperties object itself.
     */
    @Generated
    public AcsSmsDeliveryAttemptProperties setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get the segmentsSucceeded property: Number of segments that were successfully delivered.
     *
     * @return the segmentsSucceeded value.
     */
    @Generated
    public Integer getSegmentsSucceeded() {
        return this.segmentsSucceeded;
    }

    /**
     * Set the segmentsSucceeded property: Number of segments that were successfully delivered.
     *
     * @param segmentsSucceeded the segmentsSucceeded value to set.
     * @return the AcsSmsDeliveryAttemptProperties object itself.
     */
    @Generated
    public AcsSmsDeliveryAttemptProperties setSegmentsSucceeded(Integer segmentsSucceeded) {
        this.segmentsSucceeded = segmentsSucceeded;
        return this;
    }

    /**
     * Get the segmentsFailed property: Number of segments whose delivery failed.
     *
     * @return the segmentsFailed value.
     */
    @Generated
    public Integer getSegmentsFailed() {
        return this.segmentsFailed;
    }

    /**
     * Set the segmentsFailed property: Number of segments whose delivery failed.
     *
     * @param segmentsFailed the segmentsFailed value to set.
     * @return the AcsSmsDeliveryAttemptProperties object itself.
     */
    @Generated
    public AcsSmsDeliveryAttemptProperties setSegmentsFailed(Integer segmentsFailed) {
        this.segmentsFailed = segmentsFailed;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timestamp",
            this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeNumberField("segmentsSucceeded", this.segmentsSucceeded);
        jsonWriter.writeNumberField("segmentsFailed", this.segmentsFailed);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsSmsDeliveryAttemptProperties from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsSmsDeliveryAttemptProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsSmsDeliveryAttemptProperties.
     */
    @Generated
    public static AcsSmsDeliveryAttemptProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsSmsDeliveryAttemptProperties deserializedAcsSmsDeliveryAttemptProperties
                = new AcsSmsDeliveryAttemptProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    deserializedAcsSmsDeliveryAttemptProperties.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("segmentsSucceeded".equals(fieldName)) {
                    deserializedAcsSmsDeliveryAttemptProperties.segmentsSucceeded
                        = reader.getNullable(JsonReader::getInt);
                } else if ("segmentsFailed".equals(fieldName)) {
                    deserializedAcsSmsDeliveryAttemptProperties.segmentsFailed = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsSmsDeliveryAttemptProperties;
        });
    }
}
