// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The connected registry information if the event is generated by a connected registry.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class ContainerRegistryEventConnectedRegistry
    implements JsonSerializable<ContainerRegistryEventConnectedRegistry> {

    /*
     * The name of the connected registry that generated this event.
     */
    @Generated
    private String name;

    /**
     * Creates an instance of ContainerRegistryEventConnectedRegistry class.
     */
    @Generated
    public ContainerRegistryEventConnectedRegistry() {
    }

    /**
     * Get the name property: The name of the connected registry that generated this event.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The name of the connected registry that generated this event.
     *
     * @param name the name value to set.
     * @return the ContainerRegistryEventConnectedRegistry object itself.
     */
    @Generated
    public ContainerRegistryEventConnectedRegistry setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerRegistryEventConnectedRegistry from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerRegistryEventConnectedRegistry if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerRegistryEventConnectedRegistry.
     */
    @Generated
    public static ContainerRegistryEventConnectedRegistry fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerRegistryEventConnectedRegistry deserializedContainerRegistryEventConnectedRegistry
                = new ContainerRegistryEventConnectedRegistry();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedContainerRegistryEventConnectedRegistry.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedContainerRegistryEventConnectedRegistry;
        });
    }
}
