// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * Event data for Microsoft.EventGrid.MQTTClientCreatedOrUpdated event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class EventGridMqttClientCreatedOrUpdatedEventData extends EventGridMqttClientEventData {

    /*
     * Configured state of the client. The value could be Enabled or Disabled
     */
    @Generated
    private EventGridMqttClientState state;

    /*
     * Time the client resource is created based on the provider's UTC time.
     */
    @Generated
    private OffsetDateTime createdOn;

    /*
     * Time the client resource is last updated based on the provider's UTC time. If the client resource was never
     * updated, this value is identical to the value of the 'createdOn' property.
     */
    @Generated
    private OffsetDateTime updatedOn;

    /*
     * The key-value attributes that are assigned to the client resource.
     */
    @Generated
    private Map<String, String> attributes;

    /**
     * Creates an instance of EventGridMqttClientCreatedOrUpdatedEventData class.
     */
    @Generated
    public EventGridMqttClientCreatedOrUpdatedEventData() {
    }

    /**
     * Get the state property: Configured state of the client. The value could be Enabled or Disabled.
     *
     * @return the state value.
     */
    @Generated
    public EventGridMqttClientState getState() {
        return this.state;
    }

    /**
     * Set the state property: Configured state of the client. The value could be Enabled or Disabled.
     *
     * @param state the state value to set.
     * @return the EventGridMqttClientCreatedOrUpdatedEventData object itself.
     */
    @Generated
    public EventGridMqttClientCreatedOrUpdatedEventData setState(EventGridMqttClientState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the createdOn property: Time the client resource is created based on the provider's UTC time.
     *
     * @return the createdOn value.
     */
    @Generated
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    /**
     * Set the createdOn property: Time the client resource is created based on the provider's UTC time.
     *
     * @param createdOn the createdOn value to set.
     * @return the EventGridMqttClientCreatedOrUpdatedEventData object itself.
     */
    @Generated
    public EventGridMqttClientCreatedOrUpdatedEventData setCreatedOn(OffsetDateTime createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    /**
     * Get the updatedOn property: Time the client resource is last updated based on the provider's UTC time. If the
     * client resource was never updated, this value is identical to the value of the 'createdOn' property.
     *
     * @return the updatedOn value.
     */
    @Generated
    public OffsetDateTime getUpdatedOn() {
        return this.updatedOn;
    }

    /**
     * Set the updatedOn property: Time the client resource is last updated based on the provider's UTC time. If the
     * client resource was never updated, this value is identical to the value of the 'createdOn' property.
     *
     * @param updatedOn the updatedOn value to set.
     * @return the EventGridMqttClientCreatedOrUpdatedEventData object itself.
     */
    @Generated
    public EventGridMqttClientCreatedOrUpdatedEventData setUpdatedOn(OffsetDateTime updatedOn) {
        this.updatedOn = updatedOn;
        return this;
    }

    /**
     * Get the attributes property: The key-value attributes that are assigned to the client resource.
     *
     * @return the attributes value.
     */
    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    /**
     * Set the attributes property: The key-value attributes that are assigned to the client resource.
     *
     * @param attributes the attributes value to set.
     * @return the EventGridMqttClientCreatedOrUpdatedEventData object itself.
     */
    @Generated
    public EventGridMqttClientCreatedOrUpdatedEventData setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public EventGridMqttClientCreatedOrUpdatedEventData setClientAuthenticationName(String clientAuthenticationName) {
        super.setClientAuthenticationName(clientAuthenticationName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public EventGridMqttClientCreatedOrUpdatedEventData setClientName(String clientName) {
        super.setClientName(clientName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public EventGridMqttClientCreatedOrUpdatedEventData setNamespaceName(String namespaceName) {
        super.setNamespaceName(namespaceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientAuthenticationName", getClientAuthenticationName());
        jsonWriter.writeStringField("clientName", getClientName());
        jsonWriter.writeStringField("namespaceName", getNamespaceName());
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("createdOn",
            this.createdOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdOn));
        jsonWriter.writeStringField("updatedOn",
            this.updatedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updatedOn));
        jsonWriter.writeMapField("attributes", this.attributes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventGridMqttClientCreatedOrUpdatedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventGridMqttClientCreatedOrUpdatedEventData if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EventGridMqttClientCreatedOrUpdatedEventData.
     */
    @Generated
    public static EventGridMqttClientCreatedOrUpdatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventGridMqttClientCreatedOrUpdatedEventData deserializedEventGridMqttClientCreatedOrUpdatedEventData
                = new EventGridMqttClientCreatedOrUpdatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("clientAuthenticationName".equals(fieldName)) {
                    deserializedEventGridMqttClientCreatedOrUpdatedEventData
                        .setClientAuthenticationName(reader.getString());
                } else if ("clientName".equals(fieldName)) {
                    deserializedEventGridMqttClientCreatedOrUpdatedEventData.setClientName(reader.getString());
                } else if ("namespaceName".equals(fieldName)) {
                    deserializedEventGridMqttClientCreatedOrUpdatedEventData.setNamespaceName(reader.getString());
                } else if ("state".equals(fieldName)) {
                    deserializedEventGridMqttClientCreatedOrUpdatedEventData.state
                        = EventGridMqttClientState.fromString(reader.getString());
                } else if ("createdOn".equals(fieldName)) {
                    deserializedEventGridMqttClientCreatedOrUpdatedEventData.createdOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("updatedOn".equals(fieldName)) {
                    deserializedEventGridMqttClientCreatedOrUpdatedEventData.updatedOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("attributes".equals(fieldName)) {
                    Map<String, String> attributes = reader.readMap(reader1 -> reader1.getString());
                    deserializedEventGridMqttClientCreatedOrUpdatedEventData.attributes = attributes;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedEventGridMqttClientCreatedOrUpdatedEventData;
        });
    }
}
