// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.EventHub.CaptureFileCreated event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class EventHubCaptureFileCreatedEventData
    implements JsonSerializable<EventHubCaptureFileCreatedEventData> {

    /*
     * The path to the capture file.
     */
    @Generated
    private String fileurl;

    /*
     * The file type of the capture file.
     */
    @Generated
    private String fileType;

    /*
     * The shard ID.
     */
    @Generated
    private String partitionId;

    /*
     * The file size.
     */
    @Generated
    private Integer sizeInBytes;

    /*
     * The number of events in the file.
     */
    @Generated
    private Integer eventCount;

    /*
     * The smallest sequence number from the queue.
     */
    @Generated
    private Integer firstSequenceNumber;

    /*
     * The last sequence number from the queue.
     */
    @Generated
    private Integer lastSequenceNumber;

    /*
     * The first time from the queue.
     */
    @Generated
    private OffsetDateTime firstEnqueueTime;

    /*
     * The last time from the queue.
     */
    @Generated
    private OffsetDateTime lastEnqueueTime;

    /**
     * Creates an instance of EventHubCaptureFileCreatedEventData class.
     */
    @Generated
    public EventHubCaptureFileCreatedEventData() {
    }

    /**
     * Get the fileurl property: The path to the capture file.
     *
     * @return the fileurl value.
     */
    @Generated
    public String getFileurl() {
        return this.fileurl;
    }

    /**
     * Set the fileurl property: The path to the capture file.
     *
     * @param fileurl the fileurl value to set.
     * @return the EventHubCaptureFileCreatedEventData object itself.
     */
    @Generated
    public EventHubCaptureFileCreatedEventData setFileurl(String fileurl) {
        this.fileurl = fileurl;
        return this;
    }

    /**
     * Get the fileType property: The file type of the capture file.
     *
     * @return the fileType value.
     */
    @Generated
    public String getFileType() {
        return this.fileType;
    }

    /**
     * Set the fileType property: The file type of the capture file.
     *
     * @param fileType the fileType value to set.
     * @return the EventHubCaptureFileCreatedEventData object itself.
     */
    @Generated
    public EventHubCaptureFileCreatedEventData setFileType(String fileType) {
        this.fileType = fileType;
        return this;
    }

    /**
     * Get the partitionId property: The shard ID.
     *
     * @return the partitionId value.
     */
    @Generated
    public String getPartitionId() {
        return this.partitionId;
    }

    /**
     * Set the partitionId property: The shard ID.
     *
     * @param partitionId the partitionId value to set.
     * @return the EventHubCaptureFileCreatedEventData object itself.
     */
    @Generated
    public EventHubCaptureFileCreatedEventData setPartitionId(String partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    /**
     * Get the sizeInBytes property: The file size.
     *
     * @return the sizeInBytes value.
     */
    @Generated
    public Integer getSizeInBytes() {
        return this.sizeInBytes;
    }

    /**
     * Set the sizeInBytes property: The file size.
     *
     * @param sizeInBytes the sizeInBytes value to set.
     * @return the EventHubCaptureFileCreatedEventData object itself.
     */
    @Generated
    public EventHubCaptureFileCreatedEventData setSizeInBytes(Integer sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    /**
     * Get the eventCount property: The number of events in the file.
     *
     * @return the eventCount value.
     */
    @Generated
    public Integer getEventCount() {
        return this.eventCount;
    }

    /**
     * Set the eventCount property: The number of events in the file.
     *
     * @param eventCount the eventCount value to set.
     * @return the EventHubCaptureFileCreatedEventData object itself.
     */
    @Generated
    public EventHubCaptureFileCreatedEventData setEventCount(Integer eventCount) {
        this.eventCount = eventCount;
        return this;
    }

    /**
     * Get the firstSequenceNumber property: The smallest sequence number from the queue.
     *
     * @return the firstSequenceNumber value.
     */
    @Generated
    public Integer getFirstSequenceNumber() {
        return this.firstSequenceNumber;
    }

    /**
     * Set the firstSequenceNumber property: The smallest sequence number from the queue.
     *
     * @param firstSequenceNumber the firstSequenceNumber value to set.
     * @return the EventHubCaptureFileCreatedEventData object itself.
     */
    @Generated
    public EventHubCaptureFileCreatedEventData setFirstSequenceNumber(Integer firstSequenceNumber) {
        this.firstSequenceNumber = firstSequenceNumber;
        return this;
    }

    /**
     * Get the lastSequenceNumber property: The last sequence number from the queue.
     *
     * @return the lastSequenceNumber value.
     */
    @Generated
    public Integer getLastSequenceNumber() {
        return this.lastSequenceNumber;
    }

    /**
     * Set the lastSequenceNumber property: The last sequence number from the queue.
     *
     * @param lastSequenceNumber the lastSequenceNumber value to set.
     * @return the EventHubCaptureFileCreatedEventData object itself.
     */
    @Generated
    public EventHubCaptureFileCreatedEventData setLastSequenceNumber(Integer lastSequenceNumber) {
        this.lastSequenceNumber = lastSequenceNumber;
        return this;
    }

    /**
     * Get the firstEnqueueTime property: The first time from the queue.
     *
     * @return the firstEnqueueTime value.
     */
    @Generated
    public OffsetDateTime getFirstEnqueueTime() {
        return this.firstEnqueueTime;
    }

    /**
     * Set the firstEnqueueTime property: The first time from the queue.
     *
     * @param firstEnqueueTime the firstEnqueueTime value to set.
     * @return the EventHubCaptureFileCreatedEventData object itself.
     */
    @Generated
    public EventHubCaptureFileCreatedEventData setFirstEnqueueTime(OffsetDateTime firstEnqueueTime) {
        this.firstEnqueueTime = firstEnqueueTime;
        return this;
    }

    /**
     * Get the lastEnqueueTime property: The last time from the queue.
     *
     * @return the lastEnqueueTime value.
     */
    @Generated
    public OffsetDateTime getLastEnqueueTime() {
        return this.lastEnqueueTime;
    }

    /**
     * Set the lastEnqueueTime property: The last time from the queue.
     *
     * @param lastEnqueueTime the lastEnqueueTime value to set.
     * @return the EventHubCaptureFileCreatedEventData object itself.
     */
    @Generated
    public EventHubCaptureFileCreatedEventData setLastEnqueueTime(OffsetDateTime lastEnqueueTime) {
        this.lastEnqueueTime = lastEnqueueTime;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("fileUrl", this.fileurl);
        jsonWriter.writeStringField("fileType", this.fileType);
        jsonWriter.writeStringField("partitionId", this.partitionId);
        jsonWriter.writeNumberField("sizeInBytes", this.sizeInBytes);
        jsonWriter.writeNumberField("eventCount", this.eventCount);
        jsonWriter.writeNumberField("firstSequenceNumber", this.firstSequenceNumber);
        jsonWriter.writeNumberField("lastSequenceNumber", this.lastSequenceNumber);
        jsonWriter.writeStringField("firstEnqueueTime",
            this.firstEnqueueTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.firstEnqueueTime));
        jsonWriter.writeStringField("lastEnqueueTime",
            this.lastEnqueueTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastEnqueueTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EventHubCaptureFileCreatedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of EventHubCaptureFileCreatedEventData if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EventHubCaptureFileCreatedEventData.
     */
    @Generated
    public static EventHubCaptureFileCreatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EventHubCaptureFileCreatedEventData deserializedEventHubCaptureFileCreatedEventData
                = new EventHubCaptureFileCreatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileUrl".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.fileurl = reader.getString();
                } else if ("fileType".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.fileType = reader.getString();
                } else if ("partitionId".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.partitionId = reader.getString();
                } else if ("sizeInBytes".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.sizeInBytes
                        = reader.getNullable(JsonReader::getInt);
                } else if ("eventCount".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.eventCount = reader.getNullable(JsonReader::getInt);
                } else if ("firstSequenceNumber".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.firstSequenceNumber
                        = reader.getNullable(JsonReader::getInt);
                } else if ("lastSequenceNumber".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.lastSequenceNumber
                        = reader.getNullable(JsonReader::getInt);
                } else if ("firstEnqueueTime".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.firstEnqueueTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastEnqueueTime".equals(fieldName)) {
                    deserializedEventHubCaptureFileCreatedEventData.lastEnqueueTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedEventHubCaptureFileCreatedEventData;
        });
    }
}
