// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.MachineLearningServices.RunStatusChanged event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class MachineLearningServicesRunStatusChangedEventData
    implements JsonSerializable<MachineLearningServicesRunStatusChangedEventData> {

    /*
     * The ID of the experiment that the Machine Learning Run belongs to.
     */
    @Generated
    private String experimentId;

    /*
     * The name of the experiment that the Machine Learning Run belongs to.
     */
    @Generated
    private String experimentName;

    /*
     * The ID of the Machine Learning Run.
     */
    @Generated
    private String runId;

    /*
     * The Run Type of the Machine Learning Run.
     */
    @Generated
    private String runType;

    /*
     * The tags of the Machine Learning Run.
     */
    @Generated
    private Object runTags;

    /*
     * The properties of the Machine Learning Run.
     */
    @Generated
    private Object runProperties;

    /*
     * The status of the Machine Learning Run.
     */
    @Generated
    private String runStatus;

    /**
     * Creates an instance of MachineLearningServicesRunStatusChangedEventData class.
     */
    @Generated
    public MachineLearningServicesRunStatusChangedEventData() {
    }

    /**
     * Get the experimentId property: The ID of the experiment that the Machine Learning Run belongs to.
     *
     * @return the experimentId value.
     */
    @Generated
    public String getExperimentId() {
        return this.experimentId;
    }

    /**
     * Set the experimentId property: The ID of the experiment that the Machine Learning Run belongs to.
     *
     * @param experimentId the experimentId value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    @Generated
    public MachineLearningServicesRunStatusChangedEventData setExperimentId(String experimentId) {
        this.experimentId = experimentId;
        return this;
    }

    /**
     * Get the experimentName property: The name of the experiment that the Machine Learning Run belongs to.
     *
     * @return the experimentName value.
     */
    @Generated
    public String getExperimentName() {
        return this.experimentName;
    }

    /**
     * Set the experimentName property: The name of the experiment that the Machine Learning Run belongs to.
     *
     * @param experimentName the experimentName value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    @Generated
    public MachineLearningServicesRunStatusChangedEventData setExperimentName(String experimentName) {
        this.experimentName = experimentName;
        return this;
    }

    /**
     * Get the runId property: The ID of the Machine Learning Run.
     *
     * @return the runId value.
     */
    @Generated
    public String getRunId() {
        return this.runId;
    }

    /**
     * Set the runId property: The ID of the Machine Learning Run.
     *
     * @param runId the runId value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    @Generated
    public MachineLearningServicesRunStatusChangedEventData setRunId(String runId) {
        this.runId = runId;
        return this;
    }

    /**
     * Get the runType property: The Run Type of the Machine Learning Run.
     *
     * @return the runType value.
     */
    @Generated
    public String getRunType() {
        return this.runType;
    }

    /**
     * Set the runType property: The Run Type of the Machine Learning Run.
     *
     * @param runType the runType value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    @Generated
    public MachineLearningServicesRunStatusChangedEventData setRunType(String runType) {
        this.runType = runType;
        return this;
    }

    /**
     * Get the runTags property: The tags of the Machine Learning Run.
     *
     * @return the runTags value.
     */
    @Generated
    public Object getRunTags() {
        return this.runTags;
    }

    /**
     * Set the runTags property: The tags of the Machine Learning Run.
     *
     * @param runTags the runTags value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    @Generated
    public MachineLearningServicesRunStatusChangedEventData setRunTags(Object runTags) {
        this.runTags = runTags;
        return this;
    }

    /**
     * Get the runProperties property: The properties of the Machine Learning Run.
     *
     * @return the runProperties value.
     */
    @Generated
    public Object getRunProperties() {
        return this.runProperties;
    }

    /**
     * Set the runProperties property: The properties of the Machine Learning Run.
     *
     * @param runProperties the runProperties value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    @Generated
    public MachineLearningServicesRunStatusChangedEventData setRunProperties(Object runProperties) {
        this.runProperties = runProperties;
        return this;
    }

    /**
     * Get the runStatus property: The status of the Machine Learning Run.
     *
     * @return the runStatus value.
     */
    @Generated
    public String getRunStatus() {
        return this.runStatus;
    }

    /**
     * Set the runStatus property: The status of the Machine Learning Run.
     *
     * @param runStatus the runStatus value to set.
     * @return the MachineLearningServicesRunStatusChangedEventData object itself.
     */
    @Generated
    public MachineLearningServicesRunStatusChangedEventData setRunStatus(String runStatus) {
        this.runStatus = runStatus;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("experimentId", this.experimentId);
        jsonWriter.writeStringField("experimentName", this.experimentName);
        jsonWriter.writeStringField("runId", this.runId);
        jsonWriter.writeStringField("runType", this.runType);
        if (this.runTags != null) {
            jsonWriter.writeUntypedField("runTags", this.runTags);
        }
        if (this.runProperties != null) {
            jsonWriter.writeUntypedField("runProperties", this.runProperties);
        }
        jsonWriter.writeStringField("runStatus", this.runStatus);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MachineLearningServicesRunStatusChangedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MachineLearningServicesRunStatusChangedEventData if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MachineLearningServicesRunStatusChangedEventData.
     */
    @Generated
    public static MachineLearningServicesRunStatusChangedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MachineLearningServicesRunStatusChangedEventData deserializedMachineLearningServicesRunStatusChangedEventData
                = new MachineLearningServicesRunStatusChangedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("experimentId".equals(fieldName)) {
                    deserializedMachineLearningServicesRunStatusChangedEventData.experimentId = reader.getString();
                } else if ("experimentName".equals(fieldName)) {
                    deserializedMachineLearningServicesRunStatusChangedEventData.experimentName = reader.getString();
                } else if ("runId".equals(fieldName)) {
                    deserializedMachineLearningServicesRunStatusChangedEventData.runId = reader.getString();
                } else if ("runType".equals(fieldName)) {
                    deserializedMachineLearningServicesRunStatusChangedEventData.runType = reader.getString();
                } else if ("runTags".equals(fieldName)) {
                    deserializedMachineLearningServicesRunStatusChangedEventData.runTags = reader.readUntyped();
                } else if ("runProperties".equals(fieldName)) {
                    deserializedMachineLearningServicesRunStatusChangedEventData.runProperties = reader.readUntyped();
                } else if ("runStatus".equals(fieldName)) {
                    deserializedMachineLearningServicesRunStatusChangedEventData.runStatus = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedMachineLearningServicesRunStatusChangedEventData;
        });
    }
}
