// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Job canceled event data. Schema of the data property of an EventGridEvent for a Microsoft.Media.JobCanceled event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class MediaJobCanceledEventData extends MediaJobStateChangeEventData {

    /*
     * Gets the Job outputs.
     */
    @Generated
    private List<MediaJobOutput> outputs;

    /*
     * The new state of the Job.
     */
    @Generated
    private MediaJobState state;

    /*
     * The previous state of the Job.
     */
    @Generated
    private MediaJobState previousState;

    /**
     * Creates an instance of MediaJobCanceledEventData class.
     */
    @Generated
    public MediaJobCanceledEventData() {
    }

    /**
     * Get the outputs property: Gets the Job outputs.
     *
     * @return the outputs value.
     */
    @Generated
    public List<MediaJobOutput> getOutputs() {
        return this.outputs;
    }

    /**
     * Set the outputs property: Gets the Job outputs.
     *
     * @param outputs the outputs value to set.
     * @return the MediaJobCanceledEventData object itself.
     */
    @Generated
    public MediaJobCanceledEventData setOutputs(List<MediaJobOutput> outputs) {
        this.outputs = outputs;
        return this;
    }

    /**
     * Get the state property: The new state of the Job.
     *
     * @return the state value.
     */
    @Generated
    @Override
    public MediaJobState getState() {
        return this.state;
    }

    /**
     * Get the previousState property: The previous state of the Job.
     *
     * @return the previousState value.
     */
    @Generated
    @Override
    public MediaJobState getPreviousState() {
        return this.previousState;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public MediaJobCanceledEventData setCorrelationData(Map<String, String> correlationData) {
        super.setCorrelationData(correlationData);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("correlationData", getCorrelationData(),
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("outputs", this.outputs, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MediaJobCanceledEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MediaJobCanceledEventData if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MediaJobCanceledEventData.
     */
    @Generated
    public static MediaJobCanceledEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MediaJobCanceledEventData deserializedMediaJobCanceledEventData = new MediaJobCanceledEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("previousState".equals(fieldName)) {
                    deserializedMediaJobCanceledEventData.previousState = MediaJobState.fromString(reader.getString());
                } else if ("state".equals(fieldName)) {
                    deserializedMediaJobCanceledEventData.state = MediaJobState.fromString(reader.getString());
                } else if ("correlationData".equals(fieldName)) {
                    Map<String, String> correlationData = reader.readMap(reader1 -> reader1.getString());
                    deserializedMediaJobCanceledEventData.setCorrelationData(correlationData);
                } else if ("outputs".equals(fieldName)) {
                    List<MediaJobOutput> outputs = reader.readArray(reader1 -> MediaJobOutput.fromJson(reader1));
                    deserializedMediaJobCanceledEventData.outputs = outputs;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedMediaJobCanceledEventData;
        });
    }
}
