// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The event data for a Job output.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public class MediaJobOutput implements JsonSerializable<MediaJobOutput> {

    /*
     * The discriminator for derived types.
     */
    @Generated
    private String odataType = "MediaJobOutput";

    /*
     * Gets the Job output error.
     */
    @Generated
    private MediaJobError error;

    /*
     * Gets the Job output label.
     */
    @Generated
    private String label;

    /*
     * Gets the Job output progress.
     */
    @Generated
    private long progress;

    /*
     * Gets the Job output state.
     */
    @Generated
    private MediaJobState state;

    /**
     * Creates an instance of MediaJobOutput class.
     */
    @Generated
    public MediaJobOutput() {
    }

    /**
     * Get the odataType property: The discriminator for derived types.
     *
     * @return the odataType value.
     */
    @Generated
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the error property: Gets the Job output error.
     *
     * @return the error value.
     */
    @Generated
    public MediaJobError getError() {
        return this.error;
    }

    /**
     * Set the error property: Gets the Job output error.
     *
     * @param error the error value to set.
     * @return the MediaJobOutput object itself.
     */
    @Generated
    public MediaJobOutput setError(MediaJobError error) {
        this.error = error;
        return this;
    }

    /**
     * Get the label property: Gets the Job output label.
     *
     * @return the label value.
     */
    @Generated
    public String getLabel() {
        return this.label;
    }

    /**
     * Set the label property: Gets the Job output label.
     *
     * @param label the label value to set.
     * @return the MediaJobOutput object itself.
     */
    @Generated
    public MediaJobOutput setLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the progress property: Gets the Job output progress.
     *
     * @return the progress value.
     */
    @Generated
    public long getProgress() {
        return this.progress;
    }

    /**
     * Set the progress property: Gets the Job output progress.
     *
     * @param progress the progress value to set.
     * @return the MediaJobOutput object itself.
     */
    @Generated
    public MediaJobOutput setProgress(long progress) {
        this.progress = progress;
        return this;
    }

    /**
     * Get the state property: Gets the Job output state.
     *
     * @return the state value.
     */
    @Generated
    public MediaJobState getState() {
        return this.state;
    }

    /**
     * Set the state property: Gets the Job output state.
     *
     * @param state the state value to set.
     * @return the MediaJobOutput object itself.
     */
    @Generated
    public MediaJobOutput setState(MediaJobState state) {
        this.state = state;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("progress", this.progress);
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeStringField("label", this.label);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MediaJobOutput from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MediaJobOutput if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MediaJobOutput.
     */
    @Generated
    public static MediaJobOutput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                // Prepare for reading
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("#Microsoft.Media.JobOutputAsset".equals(discriminatorValue)) {
                    return MediaJobOutputAsset.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static MediaJobOutput fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MediaJobOutput deserializedMediaJobOutput = new MediaJobOutput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("progress".equals(fieldName)) {
                    deserializedMediaJobOutput.progress = reader.getLong();
                } else if ("state".equals(fieldName)) {
                    deserializedMediaJobOutput.state = MediaJobState.fromString(reader.getString());
                } else if ("@odata.type".equals(fieldName)) {
                    deserializedMediaJobOutput.odataType = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedMediaJobOutput.error = MediaJobError.fromJson(reader);
                } else if ("label".equals(fieldName)) {
                    deserializedMediaJobOutput.label = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedMediaJobOutput;
        });
    }
}
