// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Job output scheduled event data. Schema of the data property of an EventGridEvent for a
 * Microsoft.Media.JobOutputScheduled event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class MediaJobOutputScheduledEventData extends MediaJobOutputStateChangeEventData {

    /*
     * The previous state of the Job.
     */
    @Generated
    private MediaJobState previousState;

    /**
     * Creates an instance of MediaJobOutputScheduledEventData class.
     */
    @Generated
    public MediaJobOutputScheduledEventData() {
    }

    /**
     * Get the previousState property: The previous state of the Job.
     *
     * @return the previousState value.
     */
    @Generated
    @Override
    public MediaJobState getPreviousState() {
        return this.previousState;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public MediaJobOutputScheduledEventData setOutput(MediaJobOutput output) {
        super.setOutput(output);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public MediaJobOutputScheduledEventData setJobCorrelationData(Map<String, String> jobCorrelationData) {
        super.setJobCorrelationData(jobCorrelationData);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("output", getOutput());
        jsonWriter.writeMapField("jobCorrelationData", getJobCorrelationData(),
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MediaJobOutputScheduledEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MediaJobOutputScheduledEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MediaJobOutputScheduledEventData.
     */
    @Generated
    public static MediaJobOutputScheduledEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MediaJobOutputScheduledEventData deserializedMediaJobOutputScheduledEventData
                = new MediaJobOutputScheduledEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("previousState".equals(fieldName)) {
                    deserializedMediaJobOutputScheduledEventData.previousState
                        = MediaJobState.fromString(reader.getString());
                } else if ("output".equals(fieldName)) {
                    deserializedMediaJobOutputScheduledEventData.setOutput(MediaJobOutput.fromJson(reader));
                } else if ("jobCorrelationData".equals(fieldName)) {
                    Map<String, String> jobCorrelationData = reader.readMap(reader1 -> reader1.getString());
                    deserializedMediaJobOutputScheduledEventData.setJobCorrelationData(jobCorrelationData);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedMediaJobOutputScheduledEventData;
        });
    }
}
