// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Ingest fragment dropped event data. Schema of the data property of an EventGridEvent for a
 * Microsoft.Media.LiveEventIncomingDataChunkDropped event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Immutable
@Deprecated
public final class MediaLiveEventIncomingDataChunkDroppedEventData
    implements JsonSerializable<MediaLiveEventIncomingDataChunkDroppedEventData> {

    /*
     * Gets the timestamp of the data chunk dropped.
     */
    @Generated
    private String timestamp;

    /*
     * Gets the type of the track (Audio / Video).
     */
    @Generated
    private String trackType;

    /*
     * Gets the bitrate of the track.
     */
    @Generated
    private Long bitrate;

    /*
     * Gets the timescale of the Timestamp.
     */
    @Generated
    private String timescale;

    /*
     * Gets the result code for fragment drop operation.
     */
    @Generated
    private String resultCode;

    /*
     * Gets the name of the track for which fragment is dropped.
     */
    @Generated
    private String trackName;

    /**
     * Creates an instance of MediaLiveEventIncomingDataChunkDroppedEventData class.
     */
    @Generated
    public MediaLiveEventIncomingDataChunkDroppedEventData() {
    }

    /**
     * Get the timestamp property: Gets the timestamp of the data chunk dropped.
     *
     * @return the timestamp value.
     */
    @Generated
    public String getTimestamp() {
        return this.timestamp;
    }

    /**
     * Get the trackType property: Gets the type of the track (Audio / Video).
     *
     * @return the trackType value.
     */
    @Generated
    public String getTrackType() {
        return this.trackType;
    }

    /**
     * Get the bitrate property: Gets the bitrate of the track.
     *
     * @return the bitrate value.
     */
    @Generated
    public Long getBitrate() {
        return this.bitrate;
    }

    /**
     * Get the timescale property: Gets the timescale of the Timestamp.
     *
     * @return the timescale value.
     */
    @Generated
    public String getTimescale() {
        return this.timescale;
    }

    /**
     * Get the resultCode property: Gets the result code for fragment drop operation.
     *
     * @return the resultCode value.
     */
    @Generated
    public String getResultCode() {
        return this.resultCode;
    }

    /**
     * Get the trackName property: Gets the name of the track for which fragment is dropped.
     *
     * @return the trackName value.
     */
    @Generated
    public String getTrackName() {
        return this.trackName;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MediaLiveEventIncomingDataChunkDroppedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MediaLiveEventIncomingDataChunkDroppedEventData if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MediaLiveEventIncomingDataChunkDroppedEventData.
     */
    @Generated
    public static MediaLiveEventIncomingDataChunkDroppedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MediaLiveEventIncomingDataChunkDroppedEventData deserializedMediaLiveEventIncomingDataChunkDroppedEventData
                = new MediaLiveEventIncomingDataChunkDroppedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    deserializedMediaLiveEventIncomingDataChunkDroppedEventData.timestamp = reader.getString();
                } else if ("trackType".equals(fieldName)) {
                    deserializedMediaLiveEventIncomingDataChunkDroppedEventData.trackType = reader.getString();
                } else if ("bitrate".equals(fieldName)) {
                    deserializedMediaLiveEventIncomingDataChunkDroppedEventData.bitrate
                        = reader.getNullable(JsonReader::getLong);
                } else if ("timescale".equals(fieldName)) {
                    deserializedMediaLiveEventIncomingDataChunkDroppedEventData.timescale = reader.getString();
                } else if ("resultCode".equals(fieldName)) {
                    deserializedMediaLiveEventIncomingDataChunkDroppedEventData.resultCode = reader.getString();
                } else if ("trackName".equals(fieldName)) {
                    deserializedMediaLiveEventIncomingDataChunkDroppedEventData.trackName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedMediaLiveEventIncomingDataChunkDroppedEventData;
        });
    }
}
