// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Incoming video stream out of sync event data. Schema of the data property of an EventGridEvent for a
 * Microsoft.Media.LiveEventIncomingVideoStreamsOutOfSync event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Immutable
@Deprecated
public final class MediaLiveEventIncomingVideoStreamsOutOfSyncEventData
    implements JsonSerializable<MediaLiveEventIncomingVideoStreamsOutOfSyncEventData> {

    /*
     * Gets the first timestamp received for one of the quality levels.
     */
    @Generated
    private String firstTimestamp;

    /*
     * Gets the duration of the data chunk with first timestamp.
     */
    @Generated
    private String firstDuration;

    /*
     * Gets the timestamp received for some other quality levels.
     */
    @Generated
    private String secondTimestamp;

    /*
     * Gets the duration of the data chunk with second timestamp.
     */
    @Generated
    private String secondDuration;

    /*
     * Gets the timescale in which both the timestamps and durations are represented.
     */
    @Generated
    private String timescale;

    /**
     * Creates an instance of MediaLiveEventIncomingVideoStreamsOutOfSyncEventData class.
     */
    @Generated
    public MediaLiveEventIncomingVideoStreamsOutOfSyncEventData() {
    }

    /**
     * Get the firstTimestamp property: Gets the first timestamp received for one of the quality levels.
     *
     * @return the firstTimestamp value.
     */
    @Generated
    public String getFirstTimestamp() {
        return this.firstTimestamp;
    }

    /**
     * Get the firstDuration property: Gets the duration of the data chunk with first timestamp.
     *
     * @return the firstDuration value.
     */
    @Generated
    public String getFirstDuration() {
        return this.firstDuration;
    }

    /**
     * Get the secondTimestamp property: Gets the timestamp received for some other quality levels.
     *
     * @return the secondTimestamp value.
     */
    @Generated
    public String getSecondTimestamp() {
        return this.secondTimestamp;
    }

    /**
     * Get the secondDuration property: Gets the duration of the data chunk with second timestamp.
     *
     * @return the secondDuration value.
     */
    @Generated
    public String getSecondDuration() {
        return this.secondDuration;
    }

    /**
     * Get the timescale property: Gets the timescale in which both the timestamps and durations are represented.
     *
     * @return the timescale value.
     */
    @Generated
    public String getTimescale() {
        return this.timescale;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MediaLiveEventIncomingVideoStreamsOutOfSyncEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MediaLiveEventIncomingVideoStreamsOutOfSyncEventData if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MediaLiveEventIncomingVideoStreamsOutOfSyncEventData.
     */
    @Generated
    public static MediaLiveEventIncomingVideoStreamsOutOfSyncEventData fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            MediaLiveEventIncomingVideoStreamsOutOfSyncEventData deserializedMediaLiveEventIncomingVideoStreamsOutOfSyncEventData
                = new MediaLiveEventIncomingVideoStreamsOutOfSyncEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("firstTimestamp".equals(fieldName)) {
                    deserializedMediaLiveEventIncomingVideoStreamsOutOfSyncEventData.firstTimestamp
                        = reader.getString();
                } else if ("firstDuration".equals(fieldName)) {
                    deserializedMediaLiveEventIncomingVideoStreamsOutOfSyncEventData.firstDuration = reader.getString();
                } else if ("secondTimestamp".equals(fieldName)) {
                    deserializedMediaLiveEventIncomingVideoStreamsOutOfSyncEventData.secondTimestamp
                        = reader.getString();
                } else if ("secondDuration".equals(fieldName)) {
                    deserializedMediaLiveEventIncomingVideoStreamsOutOfSyncEventData.secondDuration
                        = reader.getString();
                } else if ("timescale".equals(fieldName)) {
                    deserializedMediaLiveEventIncomingVideoStreamsOutOfSyncEventData.timescale = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedMediaLiveEventIncomingVideoStreamsOutOfSyncEventData;
        });
    }
}
