// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.PolicyInsights.PolicyStateDeleted event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class PolicyInsightsPolicyStateDeletedEventData
    implements JsonSerializable<PolicyInsightsPolicyStateDeletedEventData> {

    /*
     * The time that the resource was scanned by Azure Policy in the Universal ISO 8601 DateTime format
     * yyyy-MM-ddTHH:mm:ss.fffffffZ.
     */
    @Generated
    private OffsetDateTime timestamp;

    /*
     * The resource ID of the policy assignment.
     */
    @Generated
    private String policyAssignmentId;

    /*
     * The resource ID of the policy definition.
     */
    @Generated
    private String policyDefinitionId;

    /*
     * The reference ID for the policy definition inside the initiative definition, if the policy assignment is for an
     * initiative. May be empty.
     */
    @Generated
    private String policyDefinitionReferenceId;

    /*
     * The compliance state of the resource with respect to the policy assignment.
     */
    @Generated
    private String complianceState;

    /*
     * The subscription ID of the resource.
     */
    @Generated
    private String subscriptionId;

    /*
     * The compliance reason code. May be empty.
     */
    @Generated
    private String complianceReasonCode;

    /**
     * Creates an instance of PolicyInsightsPolicyStateDeletedEventData class.
     */
    @Generated
    public PolicyInsightsPolicyStateDeletedEventData() {
    }

    /**
     * Get the timestamp property: The time that the resource was scanned by Azure Policy in the Universal ISO 8601
     * DateTime format yyyy-MM-ddTHH:mm:ss.fffffffZ.
     *
     * @return the timestamp value.
     */
    @Generated
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: The time that the resource was scanned by Azure Policy in the Universal ISO 8601
     * DateTime format yyyy-MM-ddTHH:mm:ss.fffffffZ.
     *
     * @param timestamp the timestamp value to set.
     * @return the PolicyInsightsPolicyStateDeletedEventData object itself.
     */
    @Generated
    public PolicyInsightsPolicyStateDeletedEventData setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get the policyAssignmentId property: The resource ID of the policy assignment.
     *
     * @return the policyAssignmentId value.
     */
    @Generated
    public String getPolicyAssignmentId() {
        return this.policyAssignmentId;
    }

    /**
     * Set the policyAssignmentId property: The resource ID of the policy assignment.
     *
     * @param policyAssignmentId the policyAssignmentId value to set.
     * @return the PolicyInsightsPolicyStateDeletedEventData object itself.
     */
    @Generated
    public PolicyInsightsPolicyStateDeletedEventData setPolicyAssignmentId(String policyAssignmentId) {
        this.policyAssignmentId = policyAssignmentId;
        return this;
    }

    /**
     * Get the policyDefinitionId property: The resource ID of the policy definition.
     *
     * @return the policyDefinitionId value.
     */
    @Generated
    public String getPolicyDefinitionId() {
        return this.policyDefinitionId;
    }

    /**
     * Set the policyDefinitionId property: The resource ID of the policy definition.
     *
     * @param policyDefinitionId the policyDefinitionId value to set.
     * @return the PolicyInsightsPolicyStateDeletedEventData object itself.
     */
    @Generated
    public PolicyInsightsPolicyStateDeletedEventData setPolicyDefinitionId(String policyDefinitionId) {
        this.policyDefinitionId = policyDefinitionId;
        return this;
    }

    /**
     * Get the policyDefinitionReferenceId property: The reference ID for the policy definition inside the initiative
     * definition, if the policy assignment is for an initiative. May be empty.
     *
     * @return the policyDefinitionReferenceId value.
     */
    @Generated
    public String getPolicyDefinitionReferenceId() {
        return this.policyDefinitionReferenceId;
    }

    /**
     * Set the policyDefinitionReferenceId property: The reference ID for the policy definition inside the initiative
     * definition, if the policy assignment is for an initiative. May be empty.
     *
     * @param policyDefinitionReferenceId the policyDefinitionReferenceId value to set.
     * @return the PolicyInsightsPolicyStateDeletedEventData object itself.
     */
    @Generated
    public PolicyInsightsPolicyStateDeletedEventData
        setPolicyDefinitionReferenceId(String policyDefinitionReferenceId) {
        this.policyDefinitionReferenceId = policyDefinitionReferenceId;
        return this;
    }

    /**
     * Get the complianceState property: The compliance state of the resource with respect to the policy assignment.
     *
     * @return the complianceState value.
     */
    @Generated
    public String getComplianceState() {
        return this.complianceState;
    }

    /**
     * Set the complianceState property: The compliance state of the resource with respect to the policy assignment.
     *
     * @param complianceState the complianceState value to set.
     * @return the PolicyInsightsPolicyStateDeletedEventData object itself.
     */
    @Generated
    public PolicyInsightsPolicyStateDeletedEventData setComplianceState(String complianceState) {
        this.complianceState = complianceState;
        return this;
    }

    /**
     * Get the subscriptionId property: The subscription ID of the resource.
     *
     * @return the subscriptionId value.
     */
    @Generated
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Set the subscriptionId property: The subscription ID of the resource.
     *
     * @param subscriptionId the subscriptionId value to set.
     * @return the PolicyInsightsPolicyStateDeletedEventData object itself.
     */
    @Generated
    public PolicyInsightsPolicyStateDeletedEventData setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    /**
     * Get the complianceReasonCode property: The compliance reason code. May be empty.
     *
     * @return the complianceReasonCode value.
     */
    @Generated
    public String getComplianceReasonCode() {
        return this.complianceReasonCode;
    }

    /**
     * Set the complianceReasonCode property: The compliance reason code. May be empty.
     *
     * @param complianceReasonCode the complianceReasonCode value to set.
     * @return the PolicyInsightsPolicyStateDeletedEventData object itself.
     */
    @Generated
    public PolicyInsightsPolicyStateDeletedEventData setComplianceReasonCode(String complianceReasonCode) {
        this.complianceReasonCode = complianceReasonCode;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timestamp",
            this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("policyAssignmentId", this.policyAssignmentId);
        jsonWriter.writeStringField("policyDefinitionId", this.policyDefinitionId);
        jsonWriter.writeStringField("policyDefinitionReferenceId", this.policyDefinitionReferenceId);
        jsonWriter.writeStringField("complianceState", this.complianceState);
        jsonWriter.writeStringField("subscriptionId", this.subscriptionId);
        jsonWriter.writeStringField("complianceReasonCode", this.complianceReasonCode);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyInsightsPolicyStateDeletedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyInsightsPolicyStateDeletedEventData if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicyInsightsPolicyStateDeletedEventData.
     */
    @Generated
    public static PolicyInsightsPolicyStateDeletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyInsightsPolicyStateDeletedEventData deserializedPolicyInsightsPolicyStateDeletedEventData
                = new PolicyInsightsPolicyStateDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateDeletedEventData.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("policyAssignmentId".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateDeletedEventData.policyAssignmentId = reader.getString();
                } else if ("policyDefinitionId".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateDeletedEventData.policyDefinitionId = reader.getString();
                } else if ("policyDefinitionReferenceId".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateDeletedEventData.policyDefinitionReferenceId
                        = reader.getString();
                } else if ("complianceState".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateDeletedEventData.complianceState = reader.getString();
                } else if ("subscriptionId".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateDeletedEventData.subscriptionId = reader.getString();
                } else if ("complianceReasonCode".equals(fieldName)) {
                    deserializedPolicyInsightsPolicyStateDeletedEventData.complianceReasonCode = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedPolicyInsightsPolicyStateDeletedEventData;
        });
    }
}
