// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Cache.ImportRDBCompleted event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class RedisImportRdbCompletedEventData implements JsonSerializable<RedisImportRdbCompletedEventData> {

    /*
     * The time at which the event occurred.
     */
    @Generated
    private OffsetDateTime timestamp;

    /*
     * The name of this event.
     */
    @Generated
    private String name;

    /*
     * The status of this event. Failed or succeeded
     */
    @Generated
    private String status;

    /**
     * Creates an instance of RedisImportRdbCompletedEventData class.
     */
    @Generated
    public RedisImportRdbCompletedEventData() {
    }

    /**
     * Get the timestamp property: The time at which the event occurred.
     *
     * @return the timestamp value.
     */
    @Generated
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: The time at which the event occurred.
     *
     * @param timestamp the timestamp value to set.
     * @return the RedisImportRdbCompletedEventData object itself.
     */
    @Generated
    public RedisImportRdbCompletedEventData setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get the name property: The name of this event.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The name of this event.
     *
     * @param name the name value to set.
     * @return the RedisImportRdbCompletedEventData object itself.
     */
    @Generated
    public RedisImportRdbCompletedEventData setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the status property: The status of this event. Failed or succeeded.
     *
     * @return the status value.
     */
    @Generated
    public String getStatus() {
        return this.status;
    }

    /**
     * Set the status property: The status of this event. Failed or succeeded.
     *
     * @param status the status value to set.
     * @return the RedisImportRdbCompletedEventData object itself.
     */
    @Generated
    public RedisImportRdbCompletedEventData setStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timestamp",
            this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("status", this.status);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RedisImportRdbCompletedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of RedisImportRdbCompletedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RedisImportRdbCompletedEventData.
     */
    @Generated
    public static RedisImportRdbCompletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RedisImportRdbCompletedEventData deserializedRedisImportRdbCompletedEventData
                = new RedisImportRdbCompletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    deserializedRedisImportRdbCompletedEventData.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("name".equals(fieldName)) {
                    deserializedRedisImportRdbCompletedEventData.name = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedRedisImportRdbCompletedEventData.status = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedRedisImportRdbCompletedEventData;
        });
    }
}
