// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.ResourceNotifications.Resources.CreatedOrUpdated
 * event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class ResourceNotificationsResourceManagementCreatedOrUpdatedEventData
    extends ResourceNotificationsResourceUpdatedEventData {

    /**
     * Creates an instance of ResourceNotificationsResourceManagementCreatedOrUpdatedEventData class.
     */
    @Generated
    public ResourceNotificationsResourceManagementCreatedOrUpdatedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ResourceNotificationsResourceManagementCreatedOrUpdatedEventData
        setResourceDetails(ResourceNotificationsResourceUpdatedDetails resourceDetails) {
        super.setResourceDetails(resourceDetails);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ResourceNotificationsResourceManagementCreatedOrUpdatedEventData
        setOperationalDetails(ResourceNotificationsOperationalDetails operationalDetails) {
        super.setOperationalDetails(operationalDetails);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ResourceNotificationsResourceManagementCreatedOrUpdatedEventData setApiVersion(String apiVersion) {
        super.setApiVersion(apiVersion);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resourceInfo", getResourceDetails());
        jsonWriter.writeJsonField("operationalInfo", getOperationalDetails());
        jsonWriter.writeStringField("apiVersion", getApiVersion());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceNotificationsResourceManagementCreatedOrUpdatedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceNotificationsResourceManagementCreatedOrUpdatedEventData if the JsonReader was
     * pointing to an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the
     * ResourceNotificationsResourceManagementCreatedOrUpdatedEventData.
     */
    @Generated
    public static ResourceNotificationsResourceManagementCreatedOrUpdatedEventData fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceNotificationsResourceManagementCreatedOrUpdatedEventData deserializedResourceNotificationsResourceManagementCreatedOrUpdatedEventData
                = new ResourceNotificationsResourceManagementCreatedOrUpdatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceInfo".equals(fieldName)) {
                    deserializedResourceNotificationsResourceManagementCreatedOrUpdatedEventData
                        .setResourceDetails(ResourceNotificationsResourceUpdatedDetails.fromJson(reader));
                } else if ("operationalInfo".equals(fieldName)) {
                    deserializedResourceNotificationsResourceManagementCreatedOrUpdatedEventData
                        .setOperationalDetails(ResourceNotificationsOperationalDetails.fromJson(reader));
                } else if ("apiVersion".equals(fieldName)) {
                    deserializedResourceNotificationsResourceManagementCreatedOrUpdatedEventData
                        .setApiVersion(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedResourceNotificationsResourceManagementCreatedOrUpdatedEventData;
        });
    }
}
