// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.ResourceNotifications.Resources.Deleted event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class ResourceNotificationsResourceManagementDeletedEventData
    extends ResourceNotificationsResourceDeletedEventData {

    /**
     * Creates an instance of ResourceNotificationsResourceManagementDeletedEventData class.
     */
    @Generated
    public ResourceNotificationsResourceManagementDeletedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ResourceNotificationsResourceManagementDeletedEventData
        setResourceDetails(ResourceNotificationsResourceDeletedDetails resourceDetails) {
        super.setResourceDetails(resourceDetails);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public ResourceNotificationsResourceManagementDeletedEventData
        setOperationalDetails(ResourceNotificationsOperationalDetails operationalDetails) {
        super.setOperationalDetails(operationalDetails);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("resourceInfo", getResourceDetails());
        jsonWriter.writeJsonField("operationalInfo", getOperationalDetails());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceNotificationsResourceManagementDeletedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceNotificationsResourceManagementDeletedEventData if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceNotificationsResourceManagementDeletedEventData.
     */
    @Generated
    public static ResourceNotificationsResourceManagementDeletedEventData fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceNotificationsResourceManagementDeletedEventData deserializedResourceNotificationsResourceManagementDeletedEventData
                = new ResourceNotificationsResourceManagementDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceInfo".equals(fieldName)) {
                    deserializedResourceNotificationsResourceManagementDeletedEventData
                        .setResourceDetails(ResourceNotificationsResourceDeletedDetails.fromJson(reader));
                } else if ("operationalInfo".equals(fieldName)) {
                    deserializedResourceNotificationsResourceManagementDeletedEventData
                        .setOperationalDetails(ResourceNotificationsOperationalDetails.fromJson(reader));
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedResourceNotificationsResourceManagementDeletedEventData;
        });
    }
}
