// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.SignalRService.ClientConnectionConnected event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class SignalRServiceClientConnectionConnectedEventData
    implements JsonSerializable<SignalRServiceClientConnectionConnectedEventData> {

    /*
     * The time at which the event occurred.
     */
    @Generated
    private OffsetDateTime timestamp;

    /*
     * The hub of connected client connection.
     */
    @Generated
    private String hubName;

    /*
     * The connection Id of connected client connection.
     */
    @Generated
    private String connectionId;

    /*
     * The user Id of connected client connection.
     */
    @Generated
    private String userId;

    /**
     * Creates an instance of SignalRServiceClientConnectionConnectedEventData class.
     */
    @Generated
    public SignalRServiceClientConnectionConnectedEventData() {
    }

    /**
     * Get the timestamp property: The time at which the event occurred.
     *
     * @return the timestamp value.
     */
    @Generated
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    /**
     * Set the timestamp property: The time at which the event occurred.
     *
     * @param timestamp the timestamp value to set.
     * @return the SignalRServiceClientConnectionConnectedEventData object itself.
     */
    @Generated
    public SignalRServiceClientConnectionConnectedEventData setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Get the hubName property: The hub of connected client connection.
     *
     * @return the hubName value.
     */
    @Generated
    public String getHubName() {
        return this.hubName;
    }

    /**
     * Set the hubName property: The hub of connected client connection.
     *
     * @param hubName the hubName value to set.
     * @return the SignalRServiceClientConnectionConnectedEventData object itself.
     */
    @Generated
    public SignalRServiceClientConnectionConnectedEventData setHubName(String hubName) {
        this.hubName = hubName;
        return this;
    }

    /**
     * Get the connectionId property: The connection Id of connected client connection.
     *
     * @return the connectionId value.
     */
    @Generated
    public String getConnectionId() {
        return this.connectionId;
    }

    /**
     * Set the connectionId property: The connection Id of connected client connection.
     *
     * @param connectionId the connectionId value to set.
     * @return the SignalRServiceClientConnectionConnectedEventData object itself.
     */
    @Generated
    public SignalRServiceClientConnectionConnectedEventData setConnectionId(String connectionId) {
        this.connectionId = connectionId;
        return this;
    }

    /**
     * Get the userId property: The user Id of connected client connection.
     *
     * @return the userId value.
     */
    @Generated
    public String getUserId() {
        return this.userId;
    }

    /**
     * Set the userId property: The user Id of connected client connection.
     *
     * @param userId the userId value to set.
     * @return the SignalRServiceClientConnectionConnectedEventData object itself.
     */
    @Generated
    public SignalRServiceClientConnectionConnectedEventData setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timestamp",
            this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeStringField("hubName", this.hubName);
        jsonWriter.writeStringField("connectionId", this.connectionId);
        jsonWriter.writeStringField("userId", this.userId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SignalRServiceClientConnectionConnectedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SignalRServiceClientConnectionConnectedEventData if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SignalRServiceClientConnectionConnectedEventData.
     */
    @Generated
    public static SignalRServiceClientConnectionConnectedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SignalRServiceClientConnectionConnectedEventData deserializedSignalRServiceClientConnectionConnectedEventData
                = new SignalRServiceClientConnectionConnectedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timestamp".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionConnectedEventData.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("hubName".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionConnectedEventData.hubName = reader.getString();
                } else if ("connectionId".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionConnectedEventData.connectionId = reader.getString();
                } else if ("userId".equals(fieldName)) {
                    deserializedSignalRServiceClientConnectionConnectedEventData.userId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedSignalRServiceClientConnectionConnectedEventData;
        });
    }
}
