// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Storage.DirectoryRenamed event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class StorageDirectoryRenamedEventData implements JsonSerializable<StorageDirectoryRenamedEventData> {

    /*
     * The name of the API/operation that triggered this event.
     */
    @Generated
    private String api;

    /*
     * A request id provided by the client of the storage API operation that triggered this event.
     */
    @Generated
    private String clientRequestId;

    /*
     * The request id generated by the storage service for the storage API operation that triggered this event.
     */
    @Generated
    private String requestId;

    /*
     * The path to the directory that was renamed.
     */
    @Generated
    private String sourceUrl;

    /*
     * The new path to the directory after the rename operation.
     */
    @Generated
    private String destinationUrl;

    /*
     * An opaque string value representing the logical sequence of events for any particular directory name. Users can
     * use standard string comparison to understand the relative sequence of two events on the same directory name.
     */
    @Generated
    private String sequencer;

    /*
     * The identity of the requester that triggered this event.
     */
    @Generated
    private String identity;

    /*
     * For service use only. Diagnostic data occasionally included by the Azure Storage service. This property should be
     * ignored by event consumers.
     */
    @Generated
    private Object storageDiagnostics;

    /**
     * Creates an instance of StorageDirectoryRenamedEventData class.
     */
    @Generated
    public StorageDirectoryRenamedEventData() {
    }

    /**
     * Get the api property: The name of the API/operation that triggered this event.
     *
     * @return the api value.
     */
    @Generated
    public String getApi() {
        return this.api;
    }

    /**
     * Set the api property: The name of the API/operation that triggered this event.
     *
     * @param api the api value to set.
     * @return the StorageDirectoryRenamedEventData object itself.
     */
    @Generated
    public StorageDirectoryRenamedEventData setApi(String api) {
        this.api = api;
        return this;
    }

    /**
     * Get the clientRequestId property: A request id provided by the client of the storage API operation that triggered
     * this event.
     *
     * @return the clientRequestId value.
     */
    @Generated
    public String getClientRequestId() {
        return this.clientRequestId;
    }

    /**
     * Set the clientRequestId property: A request id provided by the client of the storage API operation that triggered
     * this event.
     *
     * @param clientRequestId the clientRequestId value to set.
     * @return the StorageDirectoryRenamedEventData object itself.
     */
    @Generated
    public StorageDirectoryRenamedEventData setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    /**
     * Get the requestId property: The request id generated by the storage service for the storage API operation that
     * triggered this event.
     *
     * @return the requestId value.
     */
    @Generated
    public String getRequestId() {
        return this.requestId;
    }

    /**
     * Set the requestId property: The request id generated by the storage service for the storage API operation that
     * triggered this event.
     *
     * @param requestId the requestId value to set.
     * @return the StorageDirectoryRenamedEventData object itself.
     */
    @Generated
    public StorageDirectoryRenamedEventData setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    /**
     * Get the sourceUrl property: The path to the directory that was renamed.
     *
     * @return the sourceUrl value.
     */
    @Generated
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    /**
     * Set the sourceUrl property: The path to the directory that was renamed.
     *
     * @param sourceUrl the sourceUrl value to set.
     * @return the StorageDirectoryRenamedEventData object itself.
     */
    @Generated
    public StorageDirectoryRenamedEventData setSourceUrl(String sourceUrl) {
        this.sourceUrl = sourceUrl;
        return this;
    }

    /**
     * Get the destinationUrl property: The new path to the directory after the rename operation.
     *
     * @return the destinationUrl value.
     */
    @Generated
    public String getDestinationUrl() {
        return this.destinationUrl;
    }

    /**
     * Set the destinationUrl property: The new path to the directory after the rename operation.
     *
     * @param destinationUrl the destinationUrl value to set.
     * @return the StorageDirectoryRenamedEventData object itself.
     */
    @Generated
    public StorageDirectoryRenamedEventData setDestinationUrl(String destinationUrl) {
        this.destinationUrl = destinationUrl;
        return this;
    }

    /**
     * Get the sequencer property: An opaque string value representing the logical sequence of events for any particular
     * directory name. Users can use standard string comparison to understand the relative sequence of two events on the
     * same directory name.
     *
     * @return the sequencer value.
     */
    @Generated
    public String getSequencer() {
        return this.sequencer;
    }

    /**
     * Set the sequencer property: An opaque string value representing the logical sequence of events for any particular
     * directory name. Users can use standard string comparison to understand the relative sequence of two events on the
     * same directory name.
     *
     * @param sequencer the sequencer value to set.
     * @return the StorageDirectoryRenamedEventData object itself.
     */
    @Generated
    public StorageDirectoryRenamedEventData setSequencer(String sequencer) {
        this.sequencer = sequencer;
        return this;
    }

    /**
     * Get the identity property: The identity of the requester that triggered this event.
     *
     * @return the identity value.
     */
    @Generated
    public String getIdentity() {
        return this.identity;
    }

    /**
     * Set the identity property: The identity of the requester that triggered this event.
     *
     * @param identity the identity value to set.
     * @return the StorageDirectoryRenamedEventData object itself.
     */
    @Generated
    public StorageDirectoryRenamedEventData setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the storageDiagnostics property: For service use only. Diagnostic data occasionally included by the Azure
     * Storage service. This property should be ignored by event consumers.
     *
     * @return the storageDiagnostics value.
     */
    @Generated
    public Object getStorageDiagnostics() {
        return this.storageDiagnostics;
    }

    /**
     * Set the storageDiagnostics property: For service use only. Diagnostic data occasionally included by the Azure
     * Storage service. This property should be ignored by event consumers.
     *
     * @param storageDiagnostics the storageDiagnostics value to set.
     * @return the StorageDirectoryRenamedEventData object itself.
     */
    @Generated
    public StorageDirectoryRenamedEventData setStorageDiagnostics(Object storageDiagnostics) {
        this.storageDiagnostics = storageDiagnostics;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("api", this.api);
        jsonWriter.writeStringField("clientRequestId", this.clientRequestId);
        jsonWriter.writeStringField("requestId", this.requestId);
        jsonWriter.writeStringField("sourceUrl", this.sourceUrl);
        jsonWriter.writeStringField("destinationUrl", this.destinationUrl);
        jsonWriter.writeStringField("sequencer", this.sequencer);
        jsonWriter.writeStringField("identity", this.identity);
        if (this.storageDiagnostics != null) {
            jsonWriter.writeUntypedField("storageDiagnostics", this.storageDiagnostics);
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageDirectoryRenamedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageDirectoryRenamedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageDirectoryRenamedEventData.
     */
    @Generated
    public static StorageDirectoryRenamedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageDirectoryRenamedEventData deserializedStorageDirectoryRenamedEventData
                = new StorageDirectoryRenamedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("api".equals(fieldName)) {
                    deserializedStorageDirectoryRenamedEventData.api = reader.getString();
                } else if ("clientRequestId".equals(fieldName)) {
                    deserializedStorageDirectoryRenamedEventData.clientRequestId = reader.getString();
                } else if ("requestId".equals(fieldName)) {
                    deserializedStorageDirectoryRenamedEventData.requestId = reader.getString();
                } else if ("sourceUrl".equals(fieldName)) {
                    deserializedStorageDirectoryRenamedEventData.sourceUrl = reader.getString();
                } else if ("destinationUrl".equals(fieldName)) {
                    deserializedStorageDirectoryRenamedEventData.destinationUrl = reader.getString();
                } else if ("sequencer".equals(fieldName)) {
                    deserializedStorageDirectoryRenamedEventData.sequencer = reader.getString();
                } else if ("identity".equals(fieldName)) {
                    deserializedStorageDirectoryRenamedEventData.identity = reader.getString();
                } else if ("storageDiagnostics".equals(fieldName)) {
                    deserializedStorageDirectoryRenamedEventData.storageDiagnostics = reader.readUntyped();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedStorageDirectoryRenamedEventData;
        });
    }
}
