// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.EventGrid.SubscriptionDeletedEvent event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Immutable
@Deprecated
public final class SubscriptionDeletedEventData implements JsonSerializable<SubscriptionDeletedEventData> {

    /*
     * The Azure resource ID of the deleted event subscription.
     */
    @Generated
    private String eventSubscriptionId;

    /**
     * Creates an instance of SubscriptionDeletedEventData class.
     */
    @Generated
    public SubscriptionDeletedEventData() {
    }

    /**
     * Get the eventSubscriptionId property: The Azure resource ID of the deleted event subscription.
     *
     * @return the eventSubscriptionId value.
     */
    @Generated
    public String getEventSubscriptionId() {
        return this.eventSubscriptionId;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SubscriptionDeletedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SubscriptionDeletedEventData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SubscriptionDeletedEventData.
     */
    @Generated
    public static SubscriptionDeletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SubscriptionDeletedEventData deserializedSubscriptionDeletedEventData = new SubscriptionDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("eventSubscriptionId".equals(fieldName)) {
                    deserializedSubscriptionDeletedEventData.eventSubscriptionId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedSubscriptionDeletedEventData;
        });
    }
}
