/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventgrid;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.models.CloudEvent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventgrid.EventGridPublisherAsyncClient;
import com.azure.messaging.eventgrid.EventGridPublisherClientBuilder;
import com.azure.messaging.eventgrid.EventGridServiceVersion;
import com.azure.messaging.eventgrid.implementation.EventGridPublisherClientImpl;
import com.azure.messaging.eventgrid.implementation.EventGridPublisherClientImplBuilder;
import com.azure.messaging.eventgrid.implementation.models.EventGridEvent;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ServiceClient(builder=EventGridPublisherClientBuilder.class)
public final class EventGridPublisherClient<T> {
    private final ClientLogger logger = new ClientLogger(EventGridPublisherClient.class);
    private final EventGridPublisherClientImpl impl;
    private final String hostname;
    private final Class<T> eventClass;

    EventGridPublisherClient(HttpPipeline pipeline, String hostname, EventGridServiceVersion serviceVersion, Class<T> eventClass) {
        this.hostname = hostname;
        this.eventClass = eventClass;
        this.impl = new EventGridPublisherClientImplBuilder().pipeline(pipeline).apiVersion(serviceVersion.getVersion()).buildClient();
    }

    public static String generateSas(String endpoint, AzureKeyCredential keyCredential, OffsetDateTime expirationTime) {
        return EventGridPublisherAsyncClient.generateSas(endpoint, keyCredential, expirationTime, EventGridServiceVersion.getLatest());
    }

    public static String generateSas(String endpoint, AzureKeyCredential keyCredential, OffsetDateTime expirationTime, EventGridServiceVersion apiVersion) {
        return EventGridPublisherAsyncClient.generateSas(endpoint, keyCredential, expirationTime, apiVersion);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendEvents(Iterable<T> events) {
        if (this.eventClass == CloudEvent.class) {
            this.sendCloudEvents(events);
        } else if (this.eventClass == com.azure.messaging.eventgrid.EventGridEvent.class) {
            this.sendEventGridEvents(events);
        } else {
            this.sendCustomEvents(events);
        }
    }

    private void sendCustomEvents(Iterable<BinaryData> events) {
        if (events == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        ArrayList<Object> objectEvents = new ArrayList<Object>();
        events.forEach(objectEvents::add);
        this.impl.publishCustomEventEvents(this.hostname, objectEvents);
    }

    private void sendEventGridEvents(Iterable<com.azure.messaging.eventgrid.EventGridEvent> events) {
        if (events == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        ArrayList<EventGridEvent> eventGridEvents = new ArrayList<EventGridEvent>();
        events.forEach(event -> eventGridEvents.add(event.toImpl()));
        this.impl.publishEventGridEvents(this.hostname, eventGridEvents);
    }

    private void sendCloudEvents(Iterable<CloudEvent> events) {
        if (events == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        ArrayList<CloudEvent> cloudEvents = new ArrayList<CloudEvent>();
        events.forEach(cloudEvents::add);
        this.impl.publishCloudEventEvents(this.hostname, cloudEvents, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendEventsWithResponse(Iterable<T> events, Context context) {
        return this.sendEventsWithResponse(events, null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sendEventsWithResponse(Iterable<T> events, String channelName, Context context) {
        if (this.eventClass == CloudEvent.class) {
            return this.sendCloudEventsWithResponse(events, channelName, context);
        }
        if (this.eventClass == com.azure.messaging.eventgrid.EventGridEvent.class) {
            return this.sendEventGridEventsWithResponse(events, context);
        }
        return this.sendCustomEventsWithResponse(events, context);
    }

    private Response<Void> sendCustomEventsWithResponse(Iterable<BinaryData> events, Context context) {
        if (events == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        ArrayList<Object> objectEvents = new ArrayList<Object>();
        events.forEach(objectEvents::add);
        return this.impl.publishCustomEventEventsWithResponse(this.hostname, objectEvents, context);
    }

    private Response<Void> sendEventGridEventsWithResponse(Iterable<com.azure.messaging.eventgrid.EventGridEvent> events, Context context) {
        if (events == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        ArrayList<EventGridEvent> eventGridEvents = new ArrayList<EventGridEvent>();
        events.forEach(event -> eventGridEvents.add(event.toImpl()));
        return this.impl.publishEventGridEventsWithResponse(this.hostname, eventGridEvents, context);
    }

    private Response<Void> sendCloudEventsWithResponse(Iterable<CloudEvent> events, String channelName, Context context) {
        if (events == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        ArrayList<CloudEvent> cloudEvents = new ArrayList<CloudEvent>();
        events.forEach(cloudEvents::add);
        return this.impl.publishCloudEventEventsWithResponse(this.hostname, cloudEvents, channelName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void sendEvent(T event) {
        List<T> events = Collections.singletonList(event);
        this.sendEvents(events);
    }
}

