// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.CallEnded event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsCallEndedEventData extends AcsCallingEventProperties {

    /*
     * The communication identifier of the user who was disconnected
     */
    @Generated
    private AcsCallEndedByProperties endedBy;

    /*
     * The reason for ending the call.
     */
    @Generated
    private AcsCallEndReasonProperties reason;

    /*
     * Duration of the call in seconds.
     */
    @Generated
    private Float callDurationInSeconds;

    /**
     * Creates an instance of AcsCallEndedEventData class.
     */
    @Generated
    public AcsCallEndedEventData() {
    }

    /**
     * Get the endedBy property: The communication identifier of the user who was disconnected.
     *
     * @return the endedBy value.
     */
    @Generated
    public AcsCallEndedByProperties getEndedBy() {
        return this.endedBy;
    }

    /**
     * Set the endedBy property: The communication identifier of the user who was disconnected.
     *
     * @param endedBy the endedBy value to set.
     * @return the AcsCallEndedEventData object itself.
     */
    @Generated
    public AcsCallEndedEventData setEndedBy(AcsCallEndedByProperties endedBy) {
        this.endedBy = endedBy;
        return this;
    }

    /**
     * Get the reason property: The reason for ending the call.
     *
     * @return the reason value.
     */
    @Generated
    public AcsCallEndReasonProperties getReason() {
        return this.reason;
    }

    /**
     * Set the reason property: The reason for ending the call.
     *
     * @param reason the reason value to set.
     * @return the AcsCallEndedEventData object itself.
     */
    @Generated
    public AcsCallEndedEventData setReason(AcsCallEndReasonProperties reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Get the callDuration property: Duration of the call in seconds.
     *
     * @return the callDuration value.
     */
    @Generated
    public Duration getCallDuration() {
        if (this.callDurationInSeconds != null) {
            return Duration.ofNanos((long) (this.callDurationInSeconds * 1000_000_000L));
        }
        return null;
    }

    /**
     * Set the callDuration property: Duration of the call in seconds.
     *
     * @param callDuration the callDuration value to set.
     * @return the AcsCallEndedEventData object itself.
     */
    @Generated
    public AcsCallEndedEventData setCallDuration(Duration callDuration) {
        if (callDuration != null) {
            this.callDurationInSeconds = callDuration.toNanos() / 1_000_000_000f;
        } else {
            this.callDurationInSeconds = null;
        }
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallEndedEventData setStartedBy(AcsCallParticipantProperties startedBy) {
        super.setStartedBy(startedBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallEndedEventData setServerCallId(String serverCallId) {
        super.setServerCallId(serverCallId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallEndedEventData setGroup(AcsCallGroupProperties group) {
        super.setGroup(group);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallEndedEventData setRoom(AcsCallRoomProperties room) {
        super.setRoom(room);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallEndedEventData setIsTwoParty(Boolean isTwoParty) {
        super.setIsTwoParty(isTwoParty);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallEndedEventData setCorrelationId(String correlationId) {
        super.setCorrelationId(correlationId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallEndedEventData setIsRoomsCall(Boolean isRoomsCall) {
        super.setIsRoomsCall(isRoomsCall);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("startedBy", getStartedBy());
        jsonWriter.writeStringField("serverCallId", getServerCallId());
        jsonWriter.writeStringField("correlationId", getCorrelationId());
        jsonWriter.writeJsonField("group", getGroup());
        jsonWriter.writeJsonField("room", getRoom());
        jsonWriter.writeBooleanField("isTwoParty", isTwoParty());
        jsonWriter.writeBooleanField("isRoomsCall", isRoomsCall());
        jsonWriter.writeJsonField("endedBy", this.endedBy);
        jsonWriter.writeJsonField("reason", this.reason);
        jsonWriter.writeNumberField("callDurationInSeconds", this.callDurationInSeconds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsCallEndedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsCallEndedEventData if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsCallEndedEventData.
     */
    @Generated
    public static AcsCallEndedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsCallEndedEventData deserializedAcsCallEndedEventData = new AcsCallEndedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startedBy".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setStartedBy(AcsCallParticipantProperties.fromJson(reader));
                } else if ("serverCallId".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setServerCallId(reader.getString());
                } else if ("correlationId".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setCorrelationId(reader.getString());
                } else if ("group".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setGroup(AcsCallGroupProperties.fromJson(reader));
                } else if ("room".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setRoom(AcsCallRoomProperties.fromJson(reader));
                } else if ("isTwoParty".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setIsTwoParty(reader.getNullable(JsonReader::getBoolean));
                } else if ("isRoomsCall".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.setIsRoomsCall(reader.getNullable(JsonReader::getBoolean));
                } else if ("endedBy".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.endedBy = AcsCallEndedByProperties.fromJson(reader);
                } else if ("reason".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.reason = AcsCallEndReasonProperties.fromJson(reader);
                } else if ("callDurationInSeconds".equals(fieldName)) {
                    deserializedAcsCallEndedEventData.callDurationInSeconds = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsCallEndedEventData;
        });
    }
}
