// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.CallParticipantAdded event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsCallParticipantAddedEventData extends AcsCallParticipantEventData {

    /**
     * Creates an instance of AcsCallParticipantAddedEventData class.
     */
    @Generated
    public AcsCallParticipantAddedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantAddedEventData setUser(AcsCallParticipantProperties user) {
        super.setUser(user);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantAddedEventData setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantAddedEventData setParticipantId(String participantId) {
        super.setParticipantId(participantId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantAddedEventData setUserAgent(String userAgent) {
        super.setUserAgent(userAgent);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantAddedEventData setStartedBy(AcsCallParticipantProperties startedBy) {
        super.setStartedBy(startedBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantAddedEventData setServerCallId(String serverCallId) {
        super.setServerCallId(serverCallId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantAddedEventData setGroup(AcsCallGroupProperties group) {
        super.setGroup(group);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantAddedEventData setRoom(AcsCallRoomProperties room) {
        super.setRoom(room);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantAddedEventData setIsTwoParty(Boolean isTwoParty) {
        super.setIsTwoParty(isTwoParty);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantAddedEventData setCorrelationId(String correlationId) {
        super.setCorrelationId(correlationId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantAddedEventData setIsRoomsCall(Boolean isRoomsCall) {
        super.setIsRoomsCall(isRoomsCall);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("startedBy", getStartedBy());
        jsonWriter.writeStringField("serverCallId", getServerCallId());
        jsonWriter.writeStringField("correlationId", getCorrelationId());
        jsonWriter.writeJsonField("group", getGroup());
        jsonWriter.writeJsonField("room", getRoom());
        jsonWriter.writeBooleanField("isTwoParty", isTwoParty());
        jsonWriter.writeBooleanField("isRoomsCall", isRoomsCall());
        jsonWriter.writeJsonField("user", getUser());
        jsonWriter.writeStringField("displayName", getDisplayName());
        jsonWriter.writeStringField("participantId", getParticipantId());
        jsonWriter.writeStringField("userAgent", getUserAgent());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsCallParticipantAddedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsCallParticipantAddedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsCallParticipantAddedEventData.
     */
    @Generated
    public static AcsCallParticipantAddedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsCallParticipantAddedEventData deserializedAcsCallParticipantAddedEventData
                = new AcsCallParticipantAddedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startedBy".equals(fieldName)) {
                    deserializedAcsCallParticipantAddedEventData
                        .setStartedBy(AcsCallParticipantProperties.fromJson(reader));
                } else if ("serverCallId".equals(fieldName)) {
                    deserializedAcsCallParticipantAddedEventData.setServerCallId(reader.getString());
                } else if ("correlationId".equals(fieldName)) {
                    deserializedAcsCallParticipantAddedEventData.setCorrelationId(reader.getString());
                } else if ("group".equals(fieldName)) {
                    deserializedAcsCallParticipantAddedEventData.setGroup(AcsCallGroupProperties.fromJson(reader));
                } else if ("room".equals(fieldName)) {
                    deserializedAcsCallParticipantAddedEventData.setRoom(AcsCallRoomProperties.fromJson(reader));
                } else if ("isTwoParty".equals(fieldName)) {
                    deserializedAcsCallParticipantAddedEventData
                        .setIsTwoParty(reader.getNullable(JsonReader::getBoolean));
                } else if ("isRoomsCall".equals(fieldName)) {
                    deserializedAcsCallParticipantAddedEventData
                        .setIsRoomsCall(reader.getNullable(JsonReader::getBoolean));
                } else if ("user".equals(fieldName)) {
                    deserializedAcsCallParticipantAddedEventData.setUser(AcsCallParticipantProperties.fromJson(reader));
                } else if ("displayName".equals(fieldName)) {
                    deserializedAcsCallParticipantAddedEventData.setDisplayName(reader.getString());
                } else if ("participantId".equals(fieldName)) {
                    deserializedAcsCallParticipantAddedEventData.setParticipantId(reader.getString());
                } else if ("userAgent".equals(fieldName)) {
                    deserializedAcsCallParticipantAddedEventData.setUserAgent(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsCallParticipantAddedEventData;
        });
    }
}
