// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.CallParticipantRemoved event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsCallParticipantRemovedEventData extends AcsCallParticipantEventData {

    /**
     * Creates an instance of AcsCallParticipantRemovedEventData class.
     */
    @Generated
    public AcsCallParticipantRemovedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantRemovedEventData setUser(AcsCallParticipantProperties user) {
        super.setUser(user);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantRemovedEventData setDisplayName(String displayName) {
        super.setDisplayName(displayName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantRemovedEventData setParticipantId(String participantId) {
        super.setParticipantId(participantId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantRemovedEventData setUserAgent(String userAgent) {
        super.setUserAgent(userAgent);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantRemovedEventData setStartedBy(AcsCallParticipantProperties startedBy) {
        super.setStartedBy(startedBy);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantRemovedEventData setServerCallId(String serverCallId) {
        super.setServerCallId(serverCallId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantRemovedEventData setGroup(AcsCallGroupProperties group) {
        super.setGroup(group);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantRemovedEventData setRoom(AcsCallRoomProperties room) {
        super.setRoom(room);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantRemovedEventData setIsTwoParty(Boolean isTwoParty) {
        super.setIsTwoParty(isTwoParty);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantRemovedEventData setCorrelationId(String correlationId) {
        super.setCorrelationId(correlationId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsCallParticipantRemovedEventData setIsRoomsCall(Boolean isRoomsCall) {
        super.setIsRoomsCall(isRoomsCall);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("startedBy", getStartedBy());
        jsonWriter.writeStringField("serverCallId", getServerCallId());
        jsonWriter.writeStringField("correlationId", getCorrelationId());
        jsonWriter.writeJsonField("group", getGroup());
        jsonWriter.writeJsonField("room", getRoom());
        jsonWriter.writeBooleanField("isTwoParty", isTwoParty());
        jsonWriter.writeBooleanField("isRoomsCall", isRoomsCall());
        jsonWriter.writeJsonField("user", getUser());
        jsonWriter.writeStringField("displayName", getDisplayName());
        jsonWriter.writeStringField("participantId", getParticipantId());
        jsonWriter.writeStringField("userAgent", getUserAgent());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsCallParticipantRemovedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsCallParticipantRemovedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsCallParticipantRemovedEventData.
     */
    @Generated
    public static AcsCallParticipantRemovedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsCallParticipantRemovedEventData deserializedAcsCallParticipantRemovedEventData
                = new AcsCallParticipantRemovedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startedBy".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData
                        .setStartedBy(AcsCallParticipantProperties.fromJson(reader));
                } else if ("serverCallId".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setServerCallId(reader.getString());
                } else if ("correlationId".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setCorrelationId(reader.getString());
                } else if ("group".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setGroup(AcsCallGroupProperties.fromJson(reader));
                } else if ("room".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setRoom(AcsCallRoomProperties.fromJson(reader));
                } else if ("isTwoParty".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData
                        .setIsTwoParty(reader.getNullable(JsonReader::getBoolean));
                } else if ("isRoomsCall".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData
                        .setIsRoomsCall(reader.getNullable(JsonReader::getBoolean));
                } else if ("user".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData
                        .setUser(AcsCallParticipantProperties.fromJson(reader));
                } else if ("displayName".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setDisplayName(reader.getString());
                } else if ("participantId".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setParticipantId(reader.getString());
                } else if ("userAgent".equals(fieldName)) {
                    deserializedAcsCallParticipantRemovedEventData.setUserAgent(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsCallParticipantRemovedEventData;
        });
    }
}
