// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatThreadDeleted event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsChatThreadDeletedEventData extends AcsChatThreadEventInThreadBaseProperties {

    /*
     * The communication identifier of the user who deleted the thread
     */
    @Generated
    private CommunicationIdentifierModel deletedByCommunicationIdentifier;

    /*
     * The deletion time of the thread
     */
    @Generated
    private OffsetDateTime deleteTime;

    /**
     * Creates an instance of AcsChatThreadDeletedEventData class.
     */
    @Generated
    public AcsChatThreadDeletedEventData() {
    }

    /**
     * Get the deletedByCommunicationIdentifier property: The communication identifier of the user who deleted the
     * thread.
     *
     * @return the deletedByCommunicationIdentifier value.
     */
    @Generated
    public CommunicationIdentifierModel getDeletedByCommunicationIdentifier() {
        return this.deletedByCommunicationIdentifier;
    }

    /**
     * Set the deletedByCommunicationIdentifier property: The communication identifier of the user who deleted the
     * thread.
     *
     * @param deletedByCommunicationIdentifier the deletedByCommunicationIdentifier value to set.
     * @return the AcsChatThreadDeletedEventData object itself.
     */
    @Generated
    public AcsChatThreadDeletedEventData
        setDeletedByCommunicationIdentifier(CommunicationIdentifierModel deletedByCommunicationIdentifier) {
        this.deletedByCommunicationIdentifier = deletedByCommunicationIdentifier;
        return this;
    }

    /**
     * Get the deleteTime property: The deletion time of the thread.
     *
     * @return the deleteTime value.
     */
    @Generated
    public OffsetDateTime getDeleteTime() {
        return this.deleteTime;
    }

    /**
     * Set the deleteTime property: The deletion time of the thread.
     *
     * @param deleteTime the deleteTime value to set.
     * @return the AcsChatThreadDeletedEventData object itself.
     */
    @Generated
    public AcsChatThreadDeletedEventData setDeleteTime(OffsetDateTime deleteTime) {
        this.deleteTime = deleteTime;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatThreadDeletedEventData setCreateTime(OffsetDateTime createTime) {
        super.setCreateTime(createTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatThreadDeletedEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatThreadDeletedEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatThreadDeletedEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeStringField("createTime",
            getCreateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getCreateTime()));
        jsonWriter.writeNumberField("version", getVersion());
        jsonWriter.writeJsonField("deletedByCommunicationIdentifier", this.deletedByCommunicationIdentifier);
        jsonWriter.writeStringField("deleteTime",
            this.deleteTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deleteTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatThreadDeletedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatThreadDeletedEventData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsChatThreadDeletedEventData.
     */
    @Generated
    public static AcsChatThreadDeletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatThreadDeletedEventData deserializedAcsChatThreadDeletedEventData
                = new AcsChatThreadDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatThreadDeletedEventData.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatThreadDeletedEventData.setThreadId(reader.getString());
                } else if ("createTime".equals(fieldName)) {
                    deserializedAcsChatThreadDeletedEventData.setCreateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("version".equals(fieldName)) {
                    deserializedAcsChatThreadDeletedEventData.setVersion(reader.getNullable(JsonReader::getLong));
                } else if ("deletedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatThreadDeletedEventData.deletedByCommunicationIdentifier
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("deleteTime".equals(fieldName)) {
                    deserializedAcsChatThreadDeletedEventData.deleteTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsChatThreadDeletedEventData;
        });
    }
}
