// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatThreadPropertiesUpdated event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsChatThreadPropertiesUpdatedEventData extends AcsChatThreadEventInThreadBaseProperties {

    /*
     * The communication identifier of the user who updated the thread properties
     */
    @Generated
    private CommunicationIdentifierModel editedByCommunicationIdentifier;

    /*
     * The time at which the properties of the thread were updated
     */
    @Generated
    private OffsetDateTime editTime;

    /*
     * The updated thread properties
     */
    @Generated
    private Map<String, Object> properties;

    /*
     * The thread metadata
     */
    @Generated
    private Map<String, String> metadata;

    /**
     * Creates an instance of AcsChatThreadPropertiesUpdatedEventData class.
     */
    @Generated
    public AcsChatThreadPropertiesUpdatedEventData() {
    }

    /**
     * Get the editedByCommunicationIdentifier property: The communication identifier of the user who updated the thread
     * properties.
     *
     * @return the editedByCommunicationIdentifier value.
     */
    @Generated
    public CommunicationIdentifierModel getEditedByCommunicationIdentifier() {
        return this.editedByCommunicationIdentifier;
    }

    /**
     * Set the editedByCommunicationIdentifier property: The communication identifier of the user who updated the thread
     * properties.
     *
     * @param editedByCommunicationIdentifier the editedByCommunicationIdentifier value to set.
     * @return the AcsChatThreadPropertiesUpdatedEventData object itself.
     */
    @Generated
    public AcsChatThreadPropertiesUpdatedEventData
        setEditedByCommunicationIdentifier(CommunicationIdentifierModel editedByCommunicationIdentifier) {
        this.editedByCommunicationIdentifier = editedByCommunicationIdentifier;
        return this;
    }

    /**
     * Get the editTime property: The time at which the properties of the thread were updated.
     *
     * @return the editTime value.
     */
    @Generated
    public OffsetDateTime getEditTime() {
        return this.editTime;
    }

    /**
     * Set the editTime property: The time at which the properties of the thread were updated.
     *
     * @param editTime the editTime value to set.
     * @return the AcsChatThreadPropertiesUpdatedEventData object itself.
     */
    @Generated
    public AcsChatThreadPropertiesUpdatedEventData setEditTime(OffsetDateTime editTime) {
        this.editTime = editTime;
        return this;
    }

    /**
     * Get the properties property: The updated thread properties.
     *
     * @return the properties value.
     */
    @Generated
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: The updated thread properties.
     *
     * @param properties the properties value to set.
     * @return the AcsChatThreadPropertiesUpdatedEventData object itself.
     */
    @Generated
    public AcsChatThreadPropertiesUpdatedEventData setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the metadata property: The thread metadata.
     *
     * @return the metadata value.
     */
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The thread metadata.
     *
     * @param metadata the metadata value to set.
     * @return the AcsChatThreadPropertiesUpdatedEventData object itself.
     */
    @Generated
    public AcsChatThreadPropertiesUpdatedEventData setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatThreadPropertiesUpdatedEventData setCreateTime(OffsetDateTime createTime) {
        super.setCreateTime(createTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatThreadPropertiesUpdatedEventData setVersion(Long version) {
        super.setVersion(version);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatThreadPropertiesUpdatedEventData setTransactionId(String transactionId) {
        super.setTransactionId(transactionId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsChatThreadPropertiesUpdatedEventData setThreadId(String threadId) {
        super.setThreadId(threadId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("transactionId", getTransactionId());
        jsonWriter.writeStringField("threadId", getThreadId());
        jsonWriter.writeStringField("createTime",
            getCreateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getCreateTime()));
        jsonWriter.writeNumberField("version", getVersion());
        jsonWriter.writeJsonField("editedByCommunicationIdentifier", this.editedByCommunicationIdentifier);
        jsonWriter.writeMapField("properties", this.properties, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("editTime",
            this.editTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.editTime));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsChatThreadPropertiesUpdatedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsChatThreadPropertiesUpdatedEventData if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsChatThreadPropertiesUpdatedEventData.
     */
    @Generated
    public static AcsChatThreadPropertiesUpdatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsChatThreadPropertiesUpdatedEventData deserializedAcsChatThreadPropertiesUpdatedEventData
                = new AcsChatThreadPropertiesUpdatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("transactionId".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedEventData.setTransactionId(reader.getString());
                } else if ("threadId".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedEventData.setThreadId(reader.getString());
                } else if ("createTime".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedEventData.setCreateTime(reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                } else if ("version".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedEventData
                        .setVersion(reader.getNullable(JsonReader::getLong));
                } else if ("editedByCommunicationIdentifier".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedEventData.editedByCommunicationIdentifier
                        = CommunicationIdentifierModel.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    Map<String, Object> properties = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedAcsChatThreadPropertiesUpdatedEventData.properties = properties;
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsChatThreadPropertiesUpdatedEventData.metadata = metadata;
                } else if ("editTime".equals(fieldName)) {
                    deserializedAcsChatThreadPropertiesUpdatedEventData.editTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsChatThreadPropertiesUpdatedEventData;
        });
    }
}
