// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Detailed information about the status if any.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsEmailDeliveryReportStatusDetails
    implements JsonSerializable<AcsEmailDeliveryReportStatusDetails> {

    /*
     * Recipient Mail Server Host Name
     */
    @Generated
    private String recipientMailServerHostName;

    /*
     * Detailed status message
     */
    @Generated
    private String statusMessage;

    /**
     * Creates an instance of AcsEmailDeliveryReportStatusDetails class.
     */
    @Generated
    public AcsEmailDeliveryReportStatusDetails() {
    }

    /**
     * Get the recipientMailServerHostName property: Recipient Mail Server Host Name.
     *
     * @return the recipientMailServerHostName value.
     */
    @Generated
    public String getRecipientMailServerHostName() {
        return this.recipientMailServerHostName;
    }

    /**
     * Set the recipientMailServerHostName property: Recipient Mail Server Host Name.
     *
     * @param recipientMailServerHostName the recipientMailServerHostName value to set.
     * @return the AcsEmailDeliveryReportStatusDetails object itself.
     */
    @Generated
    public AcsEmailDeliveryReportStatusDetails setRecipientMailServerHostName(String recipientMailServerHostName) {
        this.recipientMailServerHostName = recipientMailServerHostName;
        return this;
    }

    /**
     * Get the statusMessage property: Detailed status message.
     *
     * @return the statusMessage value.
     */
    @Generated
    public String getStatusMessage() {
        return this.statusMessage;
    }

    /**
     * Set the statusMessage property: Detailed status message.
     *
     * @param statusMessage the statusMessage value to set.
     * @return the AcsEmailDeliveryReportStatusDetails object itself.
     */
    @Generated
    public AcsEmailDeliveryReportStatusDetails setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recipientMailServerHostName", this.recipientMailServerHostName);
        jsonWriter.writeStringField("statusMessage", this.statusMessage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsEmailDeliveryReportStatusDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsEmailDeliveryReportStatusDetails if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsEmailDeliveryReportStatusDetails.
     */
    @Generated
    public static AcsEmailDeliveryReportStatusDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsEmailDeliveryReportStatusDetails deserializedAcsEmailDeliveryReportStatusDetails
                = new AcsEmailDeliveryReportStatusDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recipientMailServerHostName".equals(fieldName)) {
                    deserializedAcsEmailDeliveryReportStatusDetails.recipientMailServerHostName = reader.getString();
                } else if ("statusMessage".equals(fieldName)) {
                    deserializedAcsEmailDeliveryReportStatusDetails.statusMessage = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsEmailDeliveryReportStatusDetails;
        });
    }
}
