// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Message Button Content.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsMessageButtonContent implements JsonSerializable<AcsMessageButtonContent> {

    /*
     * The Text of the button
     */
    @Generated
    private String text;

    /*
     * The Payload of the button which was clicked by the user, setup by the business
     */
    @Generated
    private String payload;

    /**
     * Creates an instance of AcsMessageButtonContent class.
     */
    @Generated
    public AcsMessageButtonContent() {
    }

    /**
     * Get the text property: The Text of the button.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The Text of the button.
     *
     * @param text the text value to set.
     * @return the AcsMessageButtonContent object itself.
     */
    @Generated
    public AcsMessageButtonContent setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the payload property: The Payload of the button which was clicked by the user, setup by the business.
     *
     * @return the payload value.
     */
    @Generated
    public String getPayload() {
        return this.payload;
    }

    /**
     * Set the payload property: The Payload of the button which was clicked by the user, setup by the business.
     *
     * @param payload the payload value to set.
     * @return the AcsMessageButtonContent object itself.
     */
    @Generated
    public AcsMessageButtonContent setPayload(String payload) {
        this.payload = payload;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("payload", this.payload);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsMessageButtonContent from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsMessageButtonContent if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsMessageButtonContent.
     */
    @Generated
    public static AcsMessageButtonContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsMessageButtonContent deserializedAcsMessageButtonContent = new AcsMessageButtonContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    deserializedAcsMessageButtonContent.text = reader.getString();
                } else if ("payload".equals(fieldName)) {
                    deserializedAcsMessageButtonContent.payload = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsMessageButtonContent;
        });
    }
}
