// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Message Interactive button reply content for a user to business message.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsMessageInteractiveButtonReplyContent
    implements JsonSerializable<AcsMessageInteractiveButtonReplyContent> {

    /*
     * The ID of the button
     */
    @Generated
    private String buttonId;

    /*
     * The title of the button
     */
    @Generated
    private String title;

    /**
     * Creates an instance of AcsMessageInteractiveButtonReplyContent class.
     */
    @Generated
    public AcsMessageInteractiveButtonReplyContent() {
    }

    /**
     * Get the buttonId property: The ID of the button.
     *
     * @return the buttonId value.
     */
    @Generated
    public String getButtonId() {
        return this.buttonId;
    }

    /**
     * Set the buttonId property: The ID of the button.
     *
     * @param buttonId the buttonId value to set.
     * @return the AcsMessageInteractiveButtonReplyContent object itself.
     */
    @Generated
    public AcsMessageInteractiveButtonReplyContent setButtonId(String buttonId) {
        this.buttonId = buttonId;
        return this;
    }

    /**
     * Get the title property: The title of the button.
     *
     * @return the title value.
     */
    @Generated
    public String getTitle() {
        return this.title;
    }

    /**
     * Set the title property: The title of the button.
     *
     * @param title the title value to set.
     * @return the AcsMessageInteractiveButtonReplyContent object itself.
     */
    @Generated
    public AcsMessageInteractiveButtonReplyContent setTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.buttonId);
        jsonWriter.writeStringField("title", this.title);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsMessageInteractiveButtonReplyContent from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsMessageInteractiveButtonReplyContent if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsMessageInteractiveButtonReplyContent.
     */
    @Generated
    public static AcsMessageInteractiveButtonReplyContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsMessageInteractiveButtonReplyContent deserializedAcsMessageInteractiveButtonReplyContent
                = new AcsMessageInteractiveButtonReplyContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAcsMessageInteractiveButtonReplyContent.buttonId = reader.getString();
                } else if ("title".equals(fieldName)) {
                    deserializedAcsMessageInteractiveButtonReplyContent.title = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsMessageInteractiveButtonReplyContent;
        });
    }
}
