// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobReceived event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsRouterJobReceivedEventData extends AcsRouterJobEventData {

    /*
     * Router Job Received Job Status
     */
    @Generated
    private AcsRouterJobStatus jobStatus;

    /*
     * Router Job Classification Policy Id
     */
    @Generated
    private String classificationPolicyId;

    /*
     * Router Job Priority
     */
    @Generated
    private Integer priority;

    /*
     * Router Job Received Requested Worker Selectors
     */
    @Generated
    private List<AcsRouterWorkerSelector> requestedWorkerSelectors;

    /*
     * Router Job Received Scheduled Time in UTC
     */
    @Generated
    private OffsetDateTime scheduledOn;

    /*
     * Unavailable For Matching for Router Job Received
     */
    @Generated
    private boolean unavailableForMatching;

    /**
     * Creates an instance of AcsRouterJobReceivedEventData class.
     */
    @Generated
    public AcsRouterJobReceivedEventData() {
    }

    /**
     * Get the jobStatus property: Router Job Received Job Status.
     *
     * @return the jobStatus value.
     */
    @Generated
    public AcsRouterJobStatus getJobStatus() {
        return this.jobStatus;
    }

    /**
     * Set the jobStatus property: Router Job Received Job Status.
     *
     * @param jobStatus the jobStatus value to set.
     * @return the AcsRouterJobReceivedEventData object itself.
     */
    @Generated
    public AcsRouterJobReceivedEventData setJobStatus(AcsRouterJobStatus jobStatus) {
        this.jobStatus = jobStatus;
        return this;
    }

    /**
     * Get the classificationPolicyId property: Router Job Classification Policy Id.
     *
     * @return the classificationPolicyId value.
     */
    @Generated
    public String getClassificationPolicyId() {
        return this.classificationPolicyId;
    }

    /**
     * Set the classificationPolicyId property: Router Job Classification Policy Id.
     *
     * @param classificationPolicyId the classificationPolicyId value to set.
     * @return the AcsRouterJobReceivedEventData object itself.
     */
    @Generated
    public AcsRouterJobReceivedEventData setClassificationPolicyId(String classificationPolicyId) {
        this.classificationPolicyId = classificationPolicyId;
        return this;
    }

    /**
     * Get the priority property: Router Job Priority.
     *
     * @return the priority value.
     */
    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    /**
     * Set the priority property: Router Job Priority.
     *
     * @param priority the priority value to set.
     * @return the AcsRouterJobReceivedEventData object itself.
     */
    @Generated
    public AcsRouterJobReceivedEventData setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the requestedWorkerSelectors property: Router Job Received Requested Worker Selectors.
     *
     * @return the requestedWorkerSelectors value.
     */
    @Generated
    public List<AcsRouterWorkerSelector> getRequestedWorkerSelectors() {
        return this.requestedWorkerSelectors;
    }

    /**
     * Set the requestedWorkerSelectors property: Router Job Received Requested Worker Selectors.
     *
     * @param requestedWorkerSelectors the requestedWorkerSelectors value to set.
     * @return the AcsRouterJobReceivedEventData object itself.
     */
    @Generated
    public AcsRouterJobReceivedEventData
        setRequestedWorkerSelectors(List<AcsRouterWorkerSelector> requestedWorkerSelectors) {
        this.requestedWorkerSelectors = requestedWorkerSelectors;
        return this;
    }

    /**
     * Get the scheduledOn property: Router Job Received Scheduled Time in UTC.
     *
     * @return the scheduledOn value.
     */
    @Generated
    public OffsetDateTime getScheduledOn() {
        return this.scheduledOn;
    }

    /**
     * Set the scheduledOn property: Router Job Received Scheduled Time in UTC.
     *
     * @param scheduledOn the scheduledOn value to set.
     * @return the AcsRouterJobReceivedEventData object itself.
     */
    @Generated
    public AcsRouterJobReceivedEventData setScheduledOn(OffsetDateTime scheduledOn) {
        this.scheduledOn = scheduledOn;
        return this;
    }

    /**
     * Get the unavailableForMatching property: Unavailable For Matching for Router Job Received.
     *
     * @return the unavailableForMatching value.
     */
    @Generated
    public Boolean isUnavailableForMatching() {
        return this.unavailableForMatching;
    }

    /**
     * Set the unavailableForMatching property: Unavailable For Matching for Router Job Received.
     *
     * @param unavailableForMatching the unavailableForMatching value to set.
     * @return the AcsRouterJobReceivedEventData object itself.
     */
    @Generated
    public AcsRouterJobReceivedEventData setUnavailableForMatching(Boolean unavailableForMatching) {
        this.unavailableForMatching = unavailableForMatching;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobReceivedEventData setQueueId(String queueId) {
        super.setQueueId(queueId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobReceivedEventData setLabels(Map<String, String> labels) {
        super.setLabels(labels);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobReceivedEventData setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobReceivedEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobReceivedEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterJobReceivedEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("labels", getLabels(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("tags", getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("jobId", getJobId());
        jsonWriter.writeStringField("channelReference", getChannelReference());
        jsonWriter.writeStringField("channelId", getChannelId());
        jsonWriter.writeStringField("queueId", getQueueId());
        jsonWriter.writeBooleanField("unavailableForMatching", this.unavailableForMatching);
        jsonWriter.writeStringField("jobStatus", this.jobStatus == null ? null : this.jobStatus.toString());
        jsonWriter.writeStringField("classificationPolicyId", this.classificationPolicyId);
        jsonWriter.writeNumberField("priority", this.priority);
        jsonWriter.writeArrayField("requestedWorkerSelectors", this.requestedWorkerSelectors,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("scheduledOn",
            this.scheduledOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduledOn));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRouterJobReceivedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRouterJobReceivedEventData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AcsRouterJobReceivedEventData.
     */
    @Generated
    public static AcsRouterJobReceivedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRouterJobReceivedEventData deserializedAcsRouterJobReceivedEventData
                = new AcsRouterJobReceivedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("labels".equals(fieldName)) {
                    Map<String, String> labels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobReceivedEventData.setLabels(labels);
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterJobReceivedEventData.setTags(tags);
                } else if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.setJobId(reader.getString());
                } else if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.setChannelReference(reader.getString());
                } else if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.setChannelId(reader.getString());
                } else if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.setQueueId(reader.getString());
                } else if ("unavailableForMatching".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.unavailableForMatching = reader.getBoolean();
                } else if ("jobStatus".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.jobStatus
                        = AcsRouterJobStatus.fromString(reader.getString());
                } else if ("classificationPolicyId".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.classificationPolicyId = reader.getString();
                } else if ("priority".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.priority = reader.getNullable(JsonReader::getInt);
                } else if ("requestedWorkerSelectors".equals(fieldName)) {
                    List<AcsRouterWorkerSelector> requestedWorkerSelectors
                        = reader.readArray(reader1 -> AcsRouterWorkerSelector.fromJson(reader1));
                    deserializedAcsRouterJobReceivedEventData.requestedWorkerSelectors = requestedWorkerSelectors;
                } else if ("scheduledOn".equals(fieldName)) {
                    deserializedAcsRouterJobReceivedEventData.scheduledOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsRouterJobReceivedEventData;
        });
    }
}
