// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterWorkerOfferAccepted event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AcsRouterWorkerOfferAcceptedEventData extends AcsRouterWorkerEventData {

    /*
     * Router Worker Offer Accepted Queue Id
     */
    @Generated
    private String queueId;

    /*
     * Router Worker Offer Accepted Offer Id
     */
    @Generated
    private String offerId;

    /*
     * Router Worker Offer Accepted Assignment Id
     */
    @Generated
    private String assignmentId;

    /*
     * Router Worker Offer Accepted Job Priority
     */
    @Generated
    private Integer jobPriority;

    /*
     * Router Worker Offer Accepted Worker Labels
     */
    @Generated
    private Map<String, String> workerLabels;

    /*
     * Router Worker Offer Accepted Worker Tags
     */
    @Generated
    private Map<String, String> workerTags;

    /*
     * Router Worker Offer Accepted Job Labels
     */
    @Generated
    private Map<String, String> jobLabels;

    /*
     * Router Worker Offer Accepted Job Tags
     */
    @Generated
    private Map<String, String> jobTags;

    /**
     * Creates an instance of AcsRouterWorkerOfferAcceptedEventData class.
     */
    @Generated
    public AcsRouterWorkerOfferAcceptedEventData() {
    }

    /**
     * Get the queueId property: Router Worker Offer Accepted Queue Id.
     *
     * @return the queueId value.
     */
    @Generated
    public String getQueueId() {
        return this.queueId;
    }

    /**
     * Set the queueId property: Router Worker Offer Accepted Queue Id.
     *
     * @param queueId the queueId value to set.
     * @return the AcsRouterWorkerOfferAcceptedEventData object itself.
     */
    @Generated
    public AcsRouterWorkerOfferAcceptedEventData setQueueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    /**
     * Get the offerId property: Router Worker Offer Accepted Offer Id.
     *
     * @return the offerId value.
     */
    @Generated
    public String getOfferId() {
        return this.offerId;
    }

    /**
     * Set the offerId property: Router Worker Offer Accepted Offer Id.
     *
     * @param offerId the offerId value to set.
     * @return the AcsRouterWorkerOfferAcceptedEventData object itself.
     */
    @Generated
    public AcsRouterWorkerOfferAcceptedEventData setOfferId(String offerId) {
        this.offerId = offerId;
        return this;
    }

    /**
     * Get the assignmentId property: Router Worker Offer Accepted Assignment Id.
     *
     * @return the assignmentId value.
     */
    @Generated
    public String getAssignmentId() {
        return this.assignmentId;
    }

    /**
     * Set the assignmentId property: Router Worker Offer Accepted Assignment Id.
     *
     * @param assignmentId the assignmentId value to set.
     * @return the AcsRouterWorkerOfferAcceptedEventData object itself.
     */
    @Generated
    public AcsRouterWorkerOfferAcceptedEventData setAssignmentId(String assignmentId) {
        this.assignmentId = assignmentId;
        return this;
    }

    /**
     * Get the jobPriority property: Router Worker Offer Accepted Job Priority.
     *
     * @return the jobPriority value.
     */
    @Generated
    public Integer getJobPriority() {
        return this.jobPriority;
    }

    /**
     * Set the jobPriority property: Router Worker Offer Accepted Job Priority.
     *
     * @param jobPriority the jobPriority value to set.
     * @return the AcsRouterWorkerOfferAcceptedEventData object itself.
     */
    @Generated
    public AcsRouterWorkerOfferAcceptedEventData setJobPriority(Integer jobPriority) {
        this.jobPriority = jobPriority;
        return this;
    }

    /**
     * Get the workerLabels property: Router Worker Offer Accepted Worker Labels.
     *
     * @return the workerLabels value.
     */
    @Generated
    public Map<String, String> getWorkerLabels() {
        return this.workerLabels;
    }

    /**
     * Set the workerLabels property: Router Worker Offer Accepted Worker Labels.
     *
     * @param workerLabels the workerLabels value to set.
     * @return the AcsRouterWorkerOfferAcceptedEventData object itself.
     */
    @Generated
    public AcsRouterWorkerOfferAcceptedEventData setWorkerLabels(Map<String, String> workerLabels) {
        this.workerLabels = workerLabels;
        return this;
    }

    /**
     * Get the workerTags property: Router Worker Offer Accepted Worker Tags.
     *
     * @return the workerTags value.
     */
    @Generated
    public Map<String, String> getWorkerTags() {
        return this.workerTags;
    }

    /**
     * Set the workerTags property: Router Worker Offer Accepted Worker Tags.
     *
     * @param workerTags the workerTags value to set.
     * @return the AcsRouterWorkerOfferAcceptedEventData object itself.
     */
    @Generated
    public AcsRouterWorkerOfferAcceptedEventData setWorkerTags(Map<String, String> workerTags) {
        this.workerTags = workerTags;
        return this;
    }

    /**
     * Get the jobLabels property: Router Worker Offer Accepted Job Labels.
     *
     * @return the jobLabels value.
     */
    @Generated
    public Map<String, String> getJobLabels() {
        return this.jobLabels;
    }

    /**
     * Set the jobLabels property: Router Worker Offer Accepted Job Labels.
     *
     * @param jobLabels the jobLabels value to set.
     * @return the AcsRouterWorkerOfferAcceptedEventData object itself.
     */
    @Generated
    public AcsRouterWorkerOfferAcceptedEventData setJobLabels(Map<String, String> jobLabels) {
        this.jobLabels = jobLabels;
        return this;
    }

    /**
     * Get the jobTags property: Router Worker Offer Accepted Job Tags.
     *
     * @return the jobTags value.
     */
    @Generated
    public Map<String, String> getJobTags() {
        return this.jobTags;
    }

    /**
     * Set the jobTags property: Router Worker Offer Accepted Job Tags.
     *
     * @param jobTags the jobTags value to set.
     * @return the AcsRouterWorkerOfferAcceptedEventData object itself.
     */
    @Generated
    public AcsRouterWorkerOfferAcceptedEventData setJobTags(Map<String, String> jobTags) {
        this.jobTags = jobTags;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterWorkerOfferAcceptedEventData setWorkerId(String workerId) {
        super.setWorkerId(workerId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterWorkerOfferAcceptedEventData setJobId(String jobId) {
        super.setJobId(jobId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterWorkerOfferAcceptedEventData setChannelReference(String channelReference) {
        super.setChannelReference(channelReference);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AcsRouterWorkerOfferAcceptedEventData setChannelId(String channelId) {
        super.setChannelId(channelId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("jobId", getJobId());
        jsonWriter.writeStringField("channelReference", getChannelReference());
        jsonWriter.writeStringField("channelId", getChannelId());
        jsonWriter.writeStringField("workerId", getWorkerId());
        jsonWriter.writeStringField("queueId", this.queueId);
        jsonWriter.writeStringField("offerId", this.offerId);
        jsonWriter.writeStringField("assignmentId", this.assignmentId);
        jsonWriter.writeNumberField("jobPriority", this.jobPriority);
        jsonWriter.writeMapField("workerLabels", this.workerLabels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("workerTags", this.workerTags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("jobLabels", this.jobLabels, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("jobTags", this.jobTags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AcsRouterWorkerOfferAcceptedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AcsRouterWorkerOfferAcceptedEventData if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AcsRouterWorkerOfferAcceptedEventData.
     */
    @Generated
    public static AcsRouterWorkerOfferAcceptedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AcsRouterWorkerOfferAcceptedEventData deserializedAcsRouterWorkerOfferAcceptedEventData
                = new AcsRouterWorkerOfferAcceptedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("jobId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferAcceptedEventData.setJobId(reader.getString());
                } else if ("channelReference".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferAcceptedEventData.setChannelReference(reader.getString());
                } else if ("channelId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferAcceptedEventData.setChannelId(reader.getString());
                } else if ("workerId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferAcceptedEventData.setWorkerId(reader.getString());
                } else if ("queueId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferAcceptedEventData.queueId = reader.getString();
                } else if ("offerId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferAcceptedEventData.offerId = reader.getString();
                } else if ("assignmentId".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferAcceptedEventData.assignmentId = reader.getString();
                } else if ("jobPriority".equals(fieldName)) {
                    deserializedAcsRouterWorkerOfferAcceptedEventData.jobPriority
                        = reader.getNullable(JsonReader::getInt);
                } else if ("workerLabels".equals(fieldName)) {
                    Map<String, String> workerLabels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterWorkerOfferAcceptedEventData.workerLabels = workerLabels;
                } else if ("workerTags".equals(fieldName)) {
                    Map<String, String> workerTags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterWorkerOfferAcceptedEventData.workerTags = workerTags;
                } else if ("jobLabels".equals(fieldName)) {
                    Map<String, String> jobLabels = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterWorkerOfferAcceptedEventData.jobLabels = jobLabels;
                } else if ("jobTags".equals(fieldName)) {
                    Map<String, String> jobTags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAcsRouterWorkerOfferAcceptedEventData.jobTags = jobTags;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAcsRouterWorkerOfferAcceptedEventData;
        });
    }
}
