// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Information related to the circuit breaker configured on the backend.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class ApiManagementCircuitBreakerProperties
    implements JsonSerializable<ApiManagementCircuitBreakerProperties> {

    /*
     * Overview of all configured rules and respective details.
     */
    @Generated
    private Map<String, Object> rules;

    /**
     * Creates an instance of ApiManagementCircuitBreakerProperties class.
     */
    @Generated
    public ApiManagementCircuitBreakerProperties() {
    }

    /**
     * Get the rules property: Overview of all configured rules and respective details.
     *
     * @return the rules value.
     */
    @Generated
    public Map<String, Object> getRules() {
        return this.rules;
    }

    /**
     * Set the rules property: Overview of all configured rules and respective details.
     *
     * @param rules the rules value to set.
     * @return the ApiManagementCircuitBreakerProperties object itself.
     */
    @Generated
    public ApiManagementCircuitBreakerProperties setRules(Map<String, Object> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("rules", this.rules, (writer, element) -> writer.writeUntyped(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementCircuitBreakerProperties from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementCircuitBreakerProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementCircuitBreakerProperties.
     */
    @Generated
    public static ApiManagementCircuitBreakerProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementCircuitBreakerProperties deserializedApiManagementCircuitBreakerProperties
                = new ApiManagementCircuitBreakerProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("rules".equals(fieldName)) {
                    Map<String, Object> rules = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedApiManagementCircuitBreakerProperties.rules = rules;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedApiManagementCircuitBreakerProperties;
        });
    }
}
