// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.ApiManagement.GatewayTokenExpired event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class ApiManagementGatewayTokenExpiredEventData
    implements JsonSerializable<ApiManagementGatewayTokenExpiredEventData> {

    /*
     * Information related to a given self-hosted gateway deployment.
     */
    @Generated
    private ApiManagementGatewayProperties gateway;

    /*
     * Information related to a an expired gateway token for a self-hosted gateway deployment.
     */
    @Generated
    private ApiManagementExpiredGatewayTokenProperties token;

    /**
     * Creates an instance of ApiManagementGatewayTokenExpiredEventData class.
     */
    @Generated
    public ApiManagementGatewayTokenExpiredEventData() {
    }

    /**
     * Get the gateway property: Information related to a given self-hosted gateway deployment.
     *
     * @return the gateway value.
     */
    @Generated
    public ApiManagementGatewayProperties getGateway() {
        return this.gateway;
    }

    /**
     * Set the gateway property: Information related to a given self-hosted gateway deployment.
     *
     * @param gateway the gateway value to set.
     * @return the ApiManagementGatewayTokenExpiredEventData object itself.
     */
    @Generated
    public ApiManagementGatewayTokenExpiredEventData setGateway(ApiManagementGatewayProperties gateway) {
        this.gateway = gateway;
        return this;
    }

    /**
     * Get the token property: Information related to a an expired gateway token for a self-hosted gateway deployment.
     *
     * @return the token value.
     */
    @Generated
    public ApiManagementExpiredGatewayTokenProperties getToken() {
        return this.token;
    }

    /**
     * Set the token property: Information related to a an expired gateway token for a self-hosted gateway deployment.
     *
     * @param token the token value to set.
     * @return the ApiManagementGatewayTokenExpiredEventData object itself.
     */
    @Generated
    public ApiManagementGatewayTokenExpiredEventData setToken(ApiManagementExpiredGatewayTokenProperties token) {
        this.token = token;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("gatewayInfo", this.gateway);
        jsonWriter.writeJsonField("tokenInfo", this.token);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementGatewayTokenExpiredEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementGatewayTokenExpiredEventData if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementGatewayTokenExpiredEventData.
     */
    @Generated
    public static ApiManagementGatewayTokenExpiredEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementGatewayTokenExpiredEventData deserializedApiManagementGatewayTokenExpiredEventData
                = new ApiManagementGatewayTokenExpiredEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("gatewayInfo".equals(fieldName)) {
                    deserializedApiManagementGatewayTokenExpiredEventData.gateway
                        = ApiManagementGatewayProperties.fromJson(reader);
                } else if ("tokenInfo".equals(fieldName)) {
                    deserializedApiManagementGatewayTokenExpiredEventData.token
                        = ApiManagementExpiredGatewayTokenProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedApiManagementGatewayTokenExpiredEventData;
        });
    }
}
