// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of common properties of snapshot events.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public class AppConfigurationSnapshotEventData implements JsonSerializable<AppConfigurationSnapshotEventData> {

    /*
     * The name of the snapshot.
     */
    @Generated
    private String name;

    /*
     * The etag representing the new state of the snapshot.
     */
    @Generated
    private String etag;

    /*
     * The sync token representing the server state after the event.
     */
    @Generated
    private String syncToken;

    /**
     * Creates an instance of AppConfigurationSnapshotEventData class.
     */
    @Generated
    public AppConfigurationSnapshotEventData() {
    }

    /**
     * Get the name property: The name of the snapshot.
     *
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The name of the snapshot.
     *
     * @param name the name value to set.
     * @return the AppConfigurationSnapshotEventData object itself.
     */
    @Generated
    public AppConfigurationSnapshotEventData setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: The etag representing the new state of the snapshot.
     *
     * @return the etag value.
     */
    @Generated
    public String getEtag() {
        return this.etag;
    }

    /**
     * Set the etag property: The etag representing the new state of the snapshot.
     *
     * @param etag the etag value to set.
     * @return the AppConfigurationSnapshotEventData object itself.
     */
    @Generated
    public AppConfigurationSnapshotEventData setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the syncToken property: The sync token representing the server state after the event.
     *
     * @return the syncToken value.
     */
    @Generated
    public String getSyncToken() {
        return this.syncToken;
    }

    /**
     * Set the syncToken property: The sync token representing the server state after the event.
     *
     * @param syncToken the syncToken value to set.
     * @return the AppConfigurationSnapshotEventData object itself.
     */
    @Generated
    public AppConfigurationSnapshotEventData setSyncToken(String syncToken) {
        this.syncToken = syncToken;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeStringField("syncToken", this.syncToken);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppConfigurationSnapshotEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppConfigurationSnapshotEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AppConfigurationSnapshotEventData.
     */
    @Generated
    public static AppConfigurationSnapshotEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppConfigurationSnapshotEventData deserializedAppConfigurationSnapshotEventData
                = new AppConfigurationSnapshotEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAppConfigurationSnapshotEventData.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedAppConfigurationSnapshotEventData.etag = reader.getString();
                } else if ("syncToken".equals(fieldName)) {
                    deserializedAppConfigurationSnapshotEventData.syncToken = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAppConfigurationSnapshotEventData;
        });
    }
}
