// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.AVS.ClusterDeleted event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AvsClusterDeletedEventData extends AvsClusterEventData {

    /**
     * Creates an instance of AvsClusterDeletedEventData class.
     */
    @Generated
    public AvsClusterDeletedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AvsClusterDeletedEventData setOperationId(String operationId) {
        super.setOperationId(operationId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AvsClusterDeletedEventData setAddedHostNames(List<String> addedHostNames) {
        super.setAddedHostNames(addedHostNames);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AvsClusterDeletedEventData setRemovedHostNames(List<String> removedHostNames) {
        super.setRemovedHostNames(removedHostNames);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AvsClusterDeletedEventData setInMaintenanceHostNames(List<String> inMaintenanceHostNames) {
        super.setInMaintenanceHostNames(inMaintenanceHostNames);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationId", getOperationId());
        jsonWriter.writeArrayField("addedHostNames", getAddedHostNames(),
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("removedHostNames", getRemovedHostNames(),
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("inMaintenanceHostNames", getInMaintenanceHostNames(),
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvsClusterDeletedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvsClusterDeletedEventData if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvsClusterDeletedEventData.
     */
    @Generated
    public static AvsClusterDeletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvsClusterDeletedEventData deserializedAvsClusterDeletedEventData = new AvsClusterDeletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    deserializedAvsClusterDeletedEventData.setOperationId(reader.getString());
                } else if ("addedHostNames".equals(fieldName)) {
                    List<String> addedHostNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAvsClusterDeletedEventData.setAddedHostNames(addedHostNames);
                } else if ("removedHostNames".equals(fieldName)) {
                    List<String> removedHostNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAvsClusterDeletedEventData.setRemovedHostNames(removedHostNames);
                } else if ("inMaintenanceHostNames".equals(fieldName)) {
                    List<String> inMaintenanceHostNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAvsClusterDeletedEventData.setInMaintenanceHostNames(inMaintenanceHostNames);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAvsClusterDeletedEventData;
        });
    }
}
