// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Schema of the Data property of an EventGridEvent for Microsoft.AVS/clusters events.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public class AvsClusterEventData implements JsonSerializable<AvsClusterEventData> {

    /*
     * Id of the operation that caused this event.
     */
    @Generated
    private String operationId;

    /*
     * Hosts added to the cluster in this event, if any.
     */
    @Generated
    private List<String> addedHostNames;

    /*
     * Hosts removed to the cluster in this event, if any.
     */
    @Generated
    private List<String> removedHostNames;

    /*
     * Hosts in Maintenance mode in the cluster, if any.
     */
    @Generated
    private List<String> inMaintenanceHostNames;

    /**
     * Creates an instance of AvsClusterEventData class.
     */
    @Generated
    public AvsClusterEventData() {
    }

    /**
     * Get the operationId property: Id of the operation that caused this event.
     *
     * @return the operationId value.
     */
    @Generated
    public String getOperationId() {
        return this.operationId;
    }

    /**
     * Set the operationId property: Id of the operation that caused this event.
     *
     * @param operationId the operationId value to set.
     * @return the AvsClusterEventData object itself.
     */
    @Generated
    public AvsClusterEventData setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    /**
     * Get the addedHostNames property: Hosts added to the cluster in this event, if any.
     *
     * @return the addedHostNames value.
     */
    @Generated
    public List<String> getAddedHostNames() {
        return this.addedHostNames;
    }

    /**
     * Set the addedHostNames property: Hosts added to the cluster in this event, if any.
     *
     * @param addedHostNames the addedHostNames value to set.
     * @return the AvsClusterEventData object itself.
     */
    @Generated
    public AvsClusterEventData setAddedHostNames(List<String> addedHostNames) {
        this.addedHostNames = addedHostNames;
        return this;
    }

    /**
     * Get the removedHostNames property: Hosts removed to the cluster in this event, if any.
     *
     * @return the removedHostNames value.
     */
    @Generated
    public List<String> getRemovedHostNames() {
        return this.removedHostNames;
    }

    /**
     * Set the removedHostNames property: Hosts removed to the cluster in this event, if any.
     *
     * @param removedHostNames the removedHostNames value to set.
     * @return the AvsClusterEventData object itself.
     */
    @Generated
    public AvsClusterEventData setRemovedHostNames(List<String> removedHostNames) {
        this.removedHostNames = removedHostNames;
        return this;
    }

    /**
     * Get the inMaintenanceHostNames property: Hosts in Maintenance mode in the cluster, if any.
     *
     * @return the inMaintenanceHostNames value.
     */
    @Generated
    public List<String> getInMaintenanceHostNames() {
        return this.inMaintenanceHostNames;
    }

    /**
     * Set the inMaintenanceHostNames property: Hosts in Maintenance mode in the cluster, if any.
     *
     * @param inMaintenanceHostNames the inMaintenanceHostNames value to set.
     * @return the AvsClusterEventData object itself.
     */
    @Generated
    public AvsClusterEventData setInMaintenanceHostNames(List<String> inMaintenanceHostNames) {
        this.inMaintenanceHostNames = inMaintenanceHostNames;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationId", this.operationId);
        jsonWriter.writeArrayField("addedHostNames", this.addedHostNames,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("removedHostNames", this.removedHostNames,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("inMaintenanceHostNames", this.inMaintenanceHostNames,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvsClusterEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvsClusterEventData if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvsClusterEventData.
     */
    @Generated
    public static AvsClusterEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvsClusterEventData deserializedAvsClusterEventData = new AvsClusterEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    deserializedAvsClusterEventData.operationId = reader.getString();
                } else if ("addedHostNames".equals(fieldName)) {
                    List<String> addedHostNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAvsClusterEventData.addedHostNames = addedHostNames;
                } else if ("removedHostNames".equals(fieldName)) {
                    List<String> removedHostNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAvsClusterEventData.removedHostNames = removedHostNames;
                } else if ("inMaintenanceHostNames".equals(fieldName)) {
                    List<String> inMaintenanceHostNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedAvsClusterEventData.inMaintenanceHostNames = inMaintenanceHostNames;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAvsClusterEventData;
        });
    }
}
