// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.AVS.PrivateCloudFailed event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AvsPrivateCloudFailedEventData extends AvsPrivateCloudEventData {

    /*
     * Failure reason of an event.
     */
    @Generated
    private String failureMessage;

    /**
     * Creates an instance of AvsPrivateCloudFailedEventData class.
     */
    @Generated
    public AvsPrivateCloudFailedEventData() {
    }

    /**
     * Get the failureMessage property: Failure reason of an event.
     *
     * @return the failureMessage value.
     */
    @Generated
    public String getFailureMessage() {
        return this.failureMessage;
    }

    /**
     * Set the failureMessage property: Failure reason of an event.
     *
     * @param failureMessage the failureMessage value to set.
     * @return the AvsPrivateCloudFailedEventData object itself.
     */
    @Generated
    public AvsPrivateCloudFailedEventData setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AvsPrivateCloudFailedEventData setOperationId(String operationId) {
        super.setOperationId(operationId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationId", getOperationId());
        jsonWriter.writeStringField("failureMessage", this.failureMessage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvsPrivateCloudFailedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvsPrivateCloudFailedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvsPrivateCloudFailedEventData.
     */
    @Generated
    public static AvsPrivateCloudFailedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvsPrivateCloudFailedEventData deserializedAvsPrivateCloudFailedEventData
                = new AvsPrivateCloudFailedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    deserializedAvsPrivateCloudFailedEventData.setOperationId(reader.getString());
                } else if ("failureMessage".equals(fieldName)) {
                    deserializedAvsPrivateCloudFailedEventData.failureMessage = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAvsPrivateCloudFailedEventData;
        });
    }
}
