// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.AVS.ScriptExecutionFinished event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class AvsScriptExecutionFinishedEventData extends AvsScriptExecutionEventData {

    /*
     * Named outputs of completed execution, if any.
     */
    @Generated
    private Map<String, String> namedOutputs;

    /**
     * Creates an instance of AvsScriptExecutionFinishedEventData class.
     */
    @Generated
    public AvsScriptExecutionFinishedEventData() {
    }

    /**
     * Get the namedOutputs property: Named outputs of completed execution, if any.
     *
     * @return the namedOutputs value.
     */
    @Generated
    public Map<String, String> getNamedOutputs() {
        return this.namedOutputs;
    }

    /**
     * Set the namedOutputs property: Named outputs of completed execution, if any.
     *
     * @param namedOutputs the namedOutputs value to set.
     * @return the AvsScriptExecutionFinishedEventData object itself.
     */
    @Generated
    public AvsScriptExecutionFinishedEventData setNamedOutputs(Map<String, String> namedOutputs) {
        this.namedOutputs = namedOutputs;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AvsScriptExecutionFinishedEventData setOperationId(String operationId) {
        super.setOperationId(operationId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AvsScriptExecutionFinishedEventData setCmdletId(String cmdletId) {
        super.setCmdletId(cmdletId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AvsScriptExecutionFinishedEventData setOutput(List<String> output) {
        super.setOutput(output);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("operationId", getOperationId());
        jsonWriter.writeStringField("cmdletId", getCmdletId());
        jsonWriter.writeArrayField("output", getOutput(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("namedOutputs", this.namedOutputs, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AvsScriptExecutionFinishedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of AvsScriptExecutionFinishedEventData if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AvsScriptExecutionFinishedEventData.
     */
    @Generated
    public static AvsScriptExecutionFinishedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AvsScriptExecutionFinishedEventData deserializedAvsScriptExecutionFinishedEventData
                = new AvsScriptExecutionFinishedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    deserializedAvsScriptExecutionFinishedEventData.setOperationId(reader.getString());
                } else if ("cmdletId".equals(fieldName)) {
                    deserializedAvsScriptExecutionFinishedEventData.setCmdletId(reader.getString());
                } else if ("output".equals(fieldName)) {
                    List<String> output = reader.readArray(reader1 -> reader1.getString());
                    deserializedAvsScriptExecutionFinishedEventData.setOutput(output);
                } else if ("namedOutputs".equals(fieldName)) {
                    Map<String, String> namedOutputs = reader.readMap(reader1 -> reader1.getString());
                    deserializedAvsScriptExecutionFinishedEventData.namedOutputs = namedOutputs;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedAvsScriptExecutionFinishedEventData;
        });
    }
}
