// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about the device twin, which is the cloud representation of application device metadata.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class DeviceTwinInfo implements JsonSerializable<DeviceTwinInfo> {

    /*
     * Authentication type used for this device: either SAS, SelfSigned, or CertificateAuthority.
     */
    @Generated
    private String authenticationType;

    /*
     * Count of cloud to device messages sent to this device.
     */
    @Generated
    private Float cloudToDeviceMessageCount;

    /*
     * Whether the device is connected or disconnected.
     */
    @Generated
    private String connectionState;

    /*
     * The unique identifier of the device twin.
     */
    @Generated
    private String deviceId;

    /*
     * A piece of information that describes the content of the device twin. Each etag is guaranteed to be unique per
     * device twin.
     */
    @Generated
    private String etag;

    /*
     * The ISO8601 timestamp of the last activity.
     */
    @Generated
    private String lastActivityTime;

    /*
     * Properties JSON element.
     */
    @Generated
    private DeviceTwinInfoProperties properties;

    /*
     * Whether the device twin is enabled or disabled.
     */
    @Generated
    private String status;

    /*
     * The ISO8601 timestamp of the last device twin status update.
     */
    @Generated
    private String statusUpdateTime;

    /*
     * An integer that is incremented by one each time the device twin is updated.
     */
    @Generated
    private Float version;

    /*
     * The thumbprint is a unique value for the x509 certificate, commonly used to find a particular certificate in a
     * certificate store. The thumbprint is dynamically generated using the SHA1 algorithm, and does not physically
     * exist in the certificate.
     */
    @Generated
    private DeviceTwinInfoX509Thumbprint x509Thumbprint;

    /**
     * Creates an instance of DeviceTwinInfo class.
     */
    @Generated
    public DeviceTwinInfo() {
    }

    /**
     * Get the authenticationType property: Authentication type used for this device: either SAS, SelfSigned, or
     * CertificateAuthority.
     *
     * @return the authenticationType value.
     */
    @Generated
    public String getAuthenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType property: Authentication type used for this device: either SAS, SelfSigned, or
     * CertificateAuthority.
     *
     * @param authenticationType the authenticationType value to set.
     * @return the DeviceTwinInfo object itself.
     */
    @Generated
    public DeviceTwinInfo setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the cloudToDeviceMessageCount property: Count of cloud to device messages sent to this device.
     *
     * @return the cloudToDeviceMessageCount value.
     */
    @Generated
    public Float getCloudToDeviceMessageCount() {
        return this.cloudToDeviceMessageCount;
    }

    /**
     * Set the cloudToDeviceMessageCount property: Count of cloud to device messages sent to this device.
     *
     * @param cloudToDeviceMessageCount the cloudToDeviceMessageCount value to set.
     * @return the DeviceTwinInfo object itself.
     */
    @Generated
    public DeviceTwinInfo setCloudToDeviceMessageCount(Float cloudToDeviceMessageCount) {
        this.cloudToDeviceMessageCount = cloudToDeviceMessageCount;
        return this;
    }

    /**
     * Get the connectionState property: Whether the device is connected or disconnected.
     *
     * @return the connectionState value.
     */
    @Generated
    public String getConnectionState() {
        return this.connectionState;
    }

    /**
     * Set the connectionState property: Whether the device is connected or disconnected.
     *
     * @param connectionState the connectionState value to set.
     * @return the DeviceTwinInfo object itself.
     */
    @Generated
    public DeviceTwinInfo setConnectionState(String connectionState) {
        this.connectionState = connectionState;
        return this;
    }

    /**
     * Get the deviceId property: The unique identifier of the device twin.
     *
     * @return the deviceId value.
     */
    @Generated
    public String getDeviceId() {
        return this.deviceId;
    }

    /**
     * Set the deviceId property: The unique identifier of the device twin.
     *
     * @param deviceId the deviceId value to set.
     * @return the DeviceTwinInfo object itself.
     */
    @Generated
    public DeviceTwinInfo setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    /**
     * Get the etag property: A piece of information that describes the content of the device twin. Each etag is
     * guaranteed to be unique per device twin.
     *
     * @return the etag value.
     */
    @Generated
    public String getEtag() {
        return this.etag;
    }

    /**
     * Set the etag property: A piece of information that describes the content of the device twin. Each etag is
     * guaranteed to be unique per device twin.
     *
     * @param etag the etag value to set.
     * @return the DeviceTwinInfo object itself.
     */
    @Generated
    public DeviceTwinInfo setEtag(String etag) {
        this.etag = etag;
        return this;
    }

    /**
     * Get the lastActivityTime property: The ISO8601 timestamp of the last activity.
     *
     * @return the lastActivityTime value.
     */
    @Generated
    public String getLastActivityTime() {
        return this.lastActivityTime;
    }

    /**
     * Set the lastActivityTime property: The ISO8601 timestamp of the last activity.
     *
     * @param lastActivityTime the lastActivityTime value to set.
     * @return the DeviceTwinInfo object itself.
     */
    @Generated
    public DeviceTwinInfo setLastActivityTime(String lastActivityTime) {
        this.lastActivityTime = lastActivityTime;
        return this;
    }

    /**
     * Get the properties property: Properties JSON element.
     *
     * @return the properties value.
     */
    @Generated
    public DeviceTwinInfoProperties getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties JSON element.
     *
     * @param properties the properties value to set.
     * @return the DeviceTwinInfo object itself.
     */
    @Generated
    public DeviceTwinInfo setProperties(DeviceTwinInfoProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the status property: Whether the device twin is enabled or disabled.
     *
     * @return the status value.
     */
    @Generated
    public String getStatus() {
        return this.status;
    }

    /**
     * Set the status property: Whether the device twin is enabled or disabled.
     *
     * @param status the status value to set.
     * @return the DeviceTwinInfo object itself.
     */
    @Generated
    public DeviceTwinInfo setStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the statusUpdateTime property: The ISO8601 timestamp of the last device twin status update.
     *
     * @return the statusUpdateTime value.
     */
    @Generated
    public String getStatusUpdateTime() {
        return this.statusUpdateTime;
    }

    /**
     * Set the statusUpdateTime property: The ISO8601 timestamp of the last device twin status update.
     *
     * @param statusUpdateTime the statusUpdateTime value to set.
     * @return the DeviceTwinInfo object itself.
     */
    @Generated
    public DeviceTwinInfo setStatusUpdateTime(String statusUpdateTime) {
        this.statusUpdateTime = statusUpdateTime;
        return this;
    }

    /**
     * Get the version property: An integer that is incremented by one each time the device twin is updated.
     *
     * @return the version value.
     */
    @Generated
    public Float getVersion() {
        return this.version;
    }

    /**
     * Set the version property: An integer that is incremented by one each time the device twin is updated.
     *
     * @param version the version value to set.
     * @return the DeviceTwinInfo object itself.
     */
    @Generated
    public DeviceTwinInfo setVersion(Float version) {
        this.version = version;
        return this;
    }

    /**
     * Get the x509Thumbprint property: The thumbprint is a unique value for the x509 certificate, commonly used to find
     * a particular certificate in a certificate store. The thumbprint is dynamically generated using the SHA1
     * algorithm, and does not physically exist in the certificate.
     *
     * @return the x509Thumbprint value.
     */
    @Generated
    public DeviceTwinInfoX509Thumbprint getX509Thumbprint() {
        return this.x509Thumbprint;
    }

    /**
     * Set the x509Thumbprint property: The thumbprint is a unique value for the x509 certificate, commonly used to find
     * a particular certificate in a certificate store. The thumbprint is dynamically generated using the SHA1
     * algorithm, and does not physically exist in the certificate.
     *
     * @param x509Thumbprint the x509Thumbprint value to set.
     * @return the DeviceTwinInfo object itself.
     */
    @Generated
    public DeviceTwinInfo setX509Thumbprint(DeviceTwinInfoX509Thumbprint x509Thumbprint) {
        this.x509Thumbprint = x509Thumbprint;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("authenticationType", this.authenticationType);
        jsonWriter.writeNumberField("cloudToDeviceMessageCount", this.cloudToDeviceMessageCount);
        jsonWriter.writeStringField("connectionState", this.connectionState);
        jsonWriter.writeStringField("deviceId", this.deviceId);
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeStringField("lastActivityTime", this.lastActivityTime);
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeStringField("statusUpdateTime", this.statusUpdateTime);
        jsonWriter.writeNumberField("version", this.version);
        jsonWriter.writeJsonField("x509Thumbprint", this.x509Thumbprint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeviceTwinInfo from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeviceTwinInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeviceTwinInfo.
     */
    @Generated
    public static DeviceTwinInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeviceTwinInfo deserializedDeviceTwinInfo = new DeviceTwinInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("authenticationType".equals(fieldName)) {
                    deserializedDeviceTwinInfo.authenticationType = reader.getString();
                } else if ("cloudToDeviceMessageCount".equals(fieldName)) {
                    deserializedDeviceTwinInfo.cloudToDeviceMessageCount = reader.getNullable(JsonReader::getFloat);
                } else if ("connectionState".equals(fieldName)) {
                    deserializedDeviceTwinInfo.connectionState = reader.getString();
                } else if ("deviceId".equals(fieldName)) {
                    deserializedDeviceTwinInfo.deviceId = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedDeviceTwinInfo.etag = reader.getString();
                } else if ("lastActivityTime".equals(fieldName)) {
                    deserializedDeviceTwinInfo.lastActivityTime = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedDeviceTwinInfo.properties = DeviceTwinInfoProperties.fromJson(reader);
                } else if ("status".equals(fieldName)) {
                    deserializedDeviceTwinInfo.status = reader.getString();
                } else if ("statusUpdateTime".equals(fieldName)) {
                    deserializedDeviceTwinInfo.statusUpdateTime = reader.getString();
                } else if ("version".equals(fieldName)) {
                    deserializedDeviceTwinInfo.version = reader.getNullable(JsonReader::getFloat);
                } else if ("x509Thumbprint".equals(fieldName)) {
                    deserializedDeviceTwinInfo.x509Thumbprint = DeviceTwinInfoX509Thumbprint.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedDeviceTwinInfo;
        });
    }
}
