// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The thumbprint is a unique value for the x509 certificate, commonly used to find a particular certificate in a
 * certificate store. The thumbprint is dynamically generated using the SHA1 algorithm, and does not physically exist in
 * the certificate.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class DeviceTwinInfoX509Thumbprint implements JsonSerializable<DeviceTwinInfoX509Thumbprint> {

    /*
     * Primary thumbprint for the x509 certificate.
     */
    @Generated
    private String primaryThumbprint;

    /*
     * Secondary thumbprint for the x509 certificate.
     */
    @Generated
    private String secondaryThumbprint;

    /**
     * Creates an instance of DeviceTwinInfoX509Thumbprint class.
     */
    @Generated
    public DeviceTwinInfoX509Thumbprint() {
    }

    /**
     * Get the primaryThumbprint property: Primary thumbprint for the x509 certificate.
     *
     * @return the primaryThumbprint value.
     */
    @Generated
    public String getPrimaryThumbprint() {
        return this.primaryThumbprint;
    }

    /**
     * Set the primaryThumbprint property: Primary thumbprint for the x509 certificate.
     *
     * @param primaryThumbprint the primaryThumbprint value to set.
     * @return the DeviceTwinInfoX509Thumbprint object itself.
     */
    @Generated
    public DeviceTwinInfoX509Thumbprint setPrimaryThumbprint(String primaryThumbprint) {
        this.primaryThumbprint = primaryThumbprint;
        return this;
    }

    /**
     * Get the secondaryThumbprint property: Secondary thumbprint for the x509 certificate.
     *
     * @return the secondaryThumbprint value.
     */
    @Generated
    public String getSecondaryThumbprint() {
        return this.secondaryThumbprint;
    }

    /**
     * Set the secondaryThumbprint property: Secondary thumbprint for the x509 certificate.
     *
     * @param secondaryThumbprint the secondaryThumbprint value to set.
     * @return the DeviceTwinInfoX509Thumbprint object itself.
     */
    @Generated
    public DeviceTwinInfoX509Thumbprint setSecondaryThumbprint(String secondaryThumbprint) {
        this.secondaryThumbprint = secondaryThumbprint;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("primaryThumbprint", this.primaryThumbprint);
        jsonWriter.writeStringField("secondaryThumbprint", this.secondaryThumbprint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeviceTwinInfoX509Thumbprint from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeviceTwinInfoX509Thumbprint if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeviceTwinInfoX509Thumbprint.
     */
    @Generated
    public static DeviceTwinInfoX509Thumbprint fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeviceTwinInfoX509Thumbprint deserializedDeviceTwinInfoX509Thumbprint = new DeviceTwinInfoX509Thumbprint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("primaryThumbprint".equals(fieldName)) {
                    deserializedDeviceTwinInfoX509Thumbprint.primaryThumbprint = reader.getString();
                } else if ("secondaryThumbprint".equals(fieldName)) {
                    deserializedDeviceTwinInfoX509Thumbprint.secondaryThumbprint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedDeviceTwinInfoX509Thumbprint;
        });
    }
}
