// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Reason for the disconnection of the MQTT client's session. The value could be one of the values in the disconnection
 * reasons table.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Deprecated
public final class EventGridMqttClientDisconnectionReason
    extends ExpandableStringEnum<EventGridMqttClientDisconnectionReason> {

    /**
     * The client got disconnected for any authentication reasons (for example, certificate expired, client got
     * disabled, or client configuration changed).
     */
    @Generated
    public static final EventGridMqttClientDisconnectionReason CLIENT_AUTHENTICATION_ERROR
        = fromString("ClientAuthenticationError");

    /**
     * The client got disconnected for any authorization reasons (for example, because of a change in the configuration
     * of topic spaces, permission bindings, or client groups).
     */
    @Generated
    public static final EventGridMqttClientDisconnectionReason CLIENT_AUTHORIZATION_ERROR
        = fromString("ClientAuthorizationError");

    /**
     * The client sent a bad request or used one of the unsupported features that resulted in a connection termination
     * by the service.
     */
    @Generated
    public static final EventGridMqttClientDisconnectionReason CLIENT_ERROR = fromString("ClientError");

    /**
     * The client initiates a graceful disconnect through a DISCONNECT packet for MQTT or a close frame for MQTT over
     * WebSocket.
     */
    @Generated
    public static final EventGridMqttClientDisconnectionReason CLIENT_INITIATED_DISCONNECT
        = fromString("ClientInitiatedDisconnect");

    /**
     * The client-server connection is lost. (EXCHANGE ONLINE PROTECTION).
     */
    @Generated
    public static final EventGridMqttClientDisconnectionReason CONNECTION_LOST = fromString("ConnectionLost");

    /**
     * The client's IP address is blocked by IP filter or Private links configuration.
     */
    @Generated
    public static final EventGridMqttClientDisconnectionReason IP_FORBIDDEN = fromString("IpForbidden");

    /**
     * The client exceeded one or more of the throttling limits that resulted in a connection termination by the
     * service.
     */
    @Generated
    public static final EventGridMqttClientDisconnectionReason QUOTA_EXCEEDED = fromString("QuotaExceeded");

    /**
     * The connection got terminated due to an unexpected server error.
     */
    @Generated
    public static final EventGridMqttClientDisconnectionReason SERVER_ERROR = fromString("ServerError");

    /**
     * The server initiates a graceful disconnect for any operational reason.
     */
    @Generated
    public static final EventGridMqttClientDisconnectionReason SERVER_INITIATED_DISCONNECT
        = fromString("ServerInitiatedDisconnect");

    /**
     * The client's queue for unacknowledged QoS1 messages reached its limit, which resulted in a connection termination
     * by the server.
     */
    @Generated
    public static final EventGridMqttClientDisconnectionReason SESSION_OVERFLOW = fromString("SessionOverflow");

    /**
     * The client reconnected with the same authentication name, which resulted in the termination of the previous
     * connection.
     */
    @Generated
    public static final EventGridMqttClientDisconnectionReason SESSION_TAKEN_OVER = fromString("SessionTakenOver");

    /**
     * Creates a new instance of EventGridMqttClientDisconnectionReason value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public EventGridMqttClientDisconnectionReason() {
    }

    /**
     * Creates or finds a EventGridMqttClientDisconnectionReason from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding EventGridMqttClientDisconnectionReason.
     */
    @Generated
    public static EventGridMqttClientDisconnectionReason fromString(String name) {
        return fromString(name, EventGridMqttClientDisconnectionReason.class);
    }

    /**
     * Gets known EventGridMqttClientDisconnectionReason values.
     *
     * @return known EventGridMqttClientDisconnectionReason values.
     */
    @Generated
    public static Collection<EventGridMqttClientDisconnectionReason> values() {
        return values(EventGridMqttClientDisconnectionReason.class);
    }
}
