// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.HealthcareApis.DicomImageCreated event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class HealthcareDicomImageCreatedEventData
    implements JsonSerializable<HealthcareDicomImageCreatedEventData> {

    /*
     * Data partition name
     */
    @Generated
    private String partitionName;

    /*
     * Unique identifier for the Study
     */
    @Generated
    private String imageStudyInstanceUid;

    /*
     * Unique identifier for the Series
     */
    @Generated
    private String imageSeriesInstanceUid;

    /*
     * Unique identifier for the DICOM Image
     */
    @Generated
    private String imageSopInstanceUid;

    /*
     * Domain name of the DICOM account for this image.
     */
    @Generated
    private String serviceHostName;

    /*
     * Sequence number of the DICOM Service within Azure Health Data Services. It is unique for every image creation and
     * deletion within the service.
     */
    @Generated
    private Long sequenceNumber;

    /**
     * Creates an instance of HealthcareDicomImageCreatedEventData class.
     */
    @Generated
    public HealthcareDicomImageCreatedEventData() {
    }

    /**
     * Get the partitionName property: Data partition name.
     *
     * @return the partitionName value.
     */
    @Generated
    public String getPartitionName() {
        return this.partitionName;
    }

    /**
     * Set the partitionName property: Data partition name.
     *
     * @param partitionName the partitionName value to set.
     * @return the HealthcareDicomImageCreatedEventData object itself.
     */
    @Generated
    public HealthcareDicomImageCreatedEventData setPartitionName(String partitionName) {
        this.partitionName = partitionName;
        return this;
    }

    /**
     * Get the imageStudyInstanceUid property: Unique identifier for the Study.
     *
     * @return the imageStudyInstanceUid value.
     */
    @Generated
    public String getImageStudyInstanceUid() {
        return this.imageStudyInstanceUid;
    }

    /**
     * Set the imageStudyInstanceUid property: Unique identifier for the Study.
     *
     * @param imageStudyInstanceUid the imageStudyInstanceUid value to set.
     * @return the HealthcareDicomImageCreatedEventData object itself.
     */
    @Generated
    public HealthcareDicomImageCreatedEventData setImageStudyInstanceUid(String imageStudyInstanceUid) {
        this.imageStudyInstanceUid = imageStudyInstanceUid;
        return this;
    }

    /**
     * Get the imageSeriesInstanceUid property: Unique identifier for the Series.
     *
     * @return the imageSeriesInstanceUid value.
     */
    @Generated
    public String getImageSeriesInstanceUid() {
        return this.imageSeriesInstanceUid;
    }

    /**
     * Set the imageSeriesInstanceUid property: Unique identifier for the Series.
     *
     * @param imageSeriesInstanceUid the imageSeriesInstanceUid value to set.
     * @return the HealthcareDicomImageCreatedEventData object itself.
     */
    @Generated
    public HealthcareDicomImageCreatedEventData setImageSeriesInstanceUid(String imageSeriesInstanceUid) {
        this.imageSeriesInstanceUid = imageSeriesInstanceUid;
        return this;
    }

    /**
     * Get the imageSopInstanceUid property: Unique identifier for the DICOM Image.
     *
     * @return the imageSopInstanceUid value.
     */
    @Generated
    public String getImageSopInstanceUid() {
        return this.imageSopInstanceUid;
    }

    /**
     * Set the imageSopInstanceUid property: Unique identifier for the DICOM Image.
     *
     * @param imageSopInstanceUid the imageSopInstanceUid value to set.
     * @return the HealthcareDicomImageCreatedEventData object itself.
     */
    @Generated
    public HealthcareDicomImageCreatedEventData setImageSopInstanceUid(String imageSopInstanceUid) {
        this.imageSopInstanceUid = imageSopInstanceUid;
        return this;
    }

    /**
     * Get the serviceHostName property: Domain name of the DICOM account for this image.
     *
     * @return the serviceHostName value.
     */
    @Generated
    public String getServiceHostName() {
        return this.serviceHostName;
    }

    /**
     * Set the serviceHostName property: Domain name of the DICOM account for this image.
     *
     * @param serviceHostName the serviceHostName value to set.
     * @return the HealthcareDicomImageCreatedEventData object itself.
     */
    @Generated
    public HealthcareDicomImageCreatedEventData setServiceHostName(String serviceHostName) {
        this.serviceHostName = serviceHostName;
        return this;
    }

    /**
     * Get the sequenceNumber property: Sequence number of the DICOM Service within Azure Health Data Services. It is
     * unique for every image creation and deletion within the service.
     *
     * @return the sequenceNumber value.
     */
    @Generated
    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    /**
     * Set the sequenceNumber property: Sequence number of the DICOM Service within Azure Health Data Services. It is
     * unique for every image creation and deletion within the service.
     *
     * @param sequenceNumber the sequenceNumber value to set.
     * @return the HealthcareDicomImageCreatedEventData object itself.
     */
    @Generated
    public HealthcareDicomImageCreatedEventData setSequenceNumber(Long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("partitionName", this.partitionName);
        jsonWriter.writeStringField("imageStudyInstanceUid", this.imageStudyInstanceUid);
        jsonWriter.writeStringField("imageSeriesInstanceUid", this.imageSeriesInstanceUid);
        jsonWriter.writeStringField("imageSopInstanceUid", this.imageSopInstanceUid);
        jsonWriter.writeStringField("serviceHostName", this.serviceHostName);
        jsonWriter.writeNumberField("sequenceNumber", this.sequenceNumber);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HealthcareDicomImageCreatedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of HealthcareDicomImageCreatedEventData if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the HealthcareDicomImageCreatedEventData.
     */
    @Generated
    public static HealthcareDicomImageCreatedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HealthcareDicomImageCreatedEventData deserializedHealthcareDicomImageCreatedEventData
                = new HealthcareDicomImageCreatedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("partitionName".equals(fieldName)) {
                    deserializedHealthcareDicomImageCreatedEventData.partitionName = reader.getString();
                } else if ("imageStudyInstanceUid".equals(fieldName)) {
                    deserializedHealthcareDicomImageCreatedEventData.imageStudyInstanceUid = reader.getString();
                } else if ("imageSeriesInstanceUid".equals(fieldName)) {
                    deserializedHealthcareDicomImageCreatedEventData.imageSeriesInstanceUid = reader.getString();
                } else if ("imageSopInstanceUid".equals(fieldName)) {
                    deserializedHealthcareDicomImageCreatedEventData.imageSopInstanceUid = reader.getString();
                } else if ("serviceHostName".equals(fieldName)) {
                    deserializedHealthcareDicomImageCreatedEventData.serviceHostName = reader.getString();
                } else if ("sequenceNumber".equals(fieldName)) {
                    deserializedHealthcareDicomImageCreatedEventData.sequenceNumber
                        = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedHealthcareDicomImageCreatedEventData;
        });
    }
}
