// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Event data for Microsoft.Devices.DeviceConnected event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class IotHubDeviceConnectedEventData extends DeviceConnectionStateEventProperties {

    /**
     * Creates an instance of IotHubDeviceConnectedEventData class.
     */
    @Generated
    public IotHubDeviceConnectedEventData() {
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public IotHubDeviceConnectedEventData setDeviceId(String deviceId) {
        super.setDeviceId(deviceId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public IotHubDeviceConnectedEventData setModuleId(String moduleId) {
        super.setModuleId(moduleId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public IotHubDeviceConnectedEventData setHubName(String hubName) {
        super.setHubName(hubName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public IotHubDeviceConnectedEventData
        setDeviceConnectionStateEventInfo(DeviceConnectionStateEventInfo deviceConnectionStateEventInfo) {
        super.setDeviceConnectionStateEventInfo(deviceConnectionStateEventInfo);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("deviceId", getDeviceId());
        jsonWriter.writeStringField("moduleId", getModuleId());
        jsonWriter.writeStringField("hubName", getHubName());
        jsonWriter.writeJsonField("deviceConnectionStateEventInfo", getDeviceConnectionStateEventInfo());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IotHubDeviceConnectedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of IotHubDeviceConnectedEventData if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the IotHubDeviceConnectedEventData.
     */
    @Generated
    public static IotHubDeviceConnectedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IotHubDeviceConnectedEventData deserializedIotHubDeviceConnectedEventData
                = new IotHubDeviceConnectedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deviceId".equals(fieldName)) {
                    deserializedIotHubDeviceConnectedEventData.setDeviceId(reader.getString());
                } else if ("moduleId".equals(fieldName)) {
                    deserializedIotHubDeviceConnectedEventData.setModuleId(reader.getString());
                } else if ("hubName".equals(fieldName)) {
                    deserializedIotHubDeviceConnectedEventData.setHubName(reader.getString());
                } else if ("deviceConnectionStateEventInfo".equals(fieldName)) {
                    deserializedIotHubDeviceConnectedEventData
                        .setDeviceConnectionStateEventInfo(DeviceConnectionStateEventInfo.fromJson(reader));
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedIotHubDeviceConnectedEventData;
        });
    }
}
