// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

/**
 * Helps with categorization of errors.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Deprecated
public enum MediaJobErrorCategory {

    /**
     * The error is service related.
     */
    SERVICE("Service"),
    /**
     * The error is download related.
     */
    DOWNLOAD("Download"),
    /**
     * The error is upload related.
     */
    UPLOAD("Upload"),
    /**
     * The error is configuration related.
     */
    CONFIGURATION("Configuration"),
    /**
     * The error is related to data in the input files.
     */
    CONTENT("Content"),
    /**
     * The error is related to account information.
     */
    ACCOUNT("Account");

    /**
     * The actual serialized value for a MediaJobErrorCategory instance.
     */
    private final String value;

    MediaJobErrorCategory(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a MediaJobErrorCategory instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed MediaJobErrorCategory object, or null if unable to parse.
     */
    public static MediaJobErrorCategory fromString(String value) {
        if (value == null) {
            return null;
        }
        MediaJobErrorCategory[] items = MediaJobErrorCategory.values();
        for (MediaJobErrorCategory item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
