// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Schema of the Data property of an EventGridEvent for a Microsoft.Media.JobStateChange event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public class MediaJobStateChangeEventData implements JsonSerializable<MediaJobStateChangeEventData> {

    /*
     * The previous state of the Job.
     */
    @Generated
    private MediaJobState previousState;

    /*
     * The new state of the Job.
     */
    @Generated
    private MediaJobState state;

    /*
     * Gets the Job correlation data.
     */
    @Generated
    private Map<String, String> correlationData;

    /**
     * Creates an instance of MediaJobStateChangeEventData class.
     */
    @Generated
    public MediaJobStateChangeEventData() {
    }

    /**
     * Get the previousState property: The previous state of the Job.
     *
     * @return the previousState value.
     */
    @Generated
    public MediaJobState getPreviousState() {
        return this.previousState;
    }

    /**
     * Set the previousState property: The previous state of the Job.
     *
     * @param previousState the previousState value to set.
     * @return the MediaJobStateChangeEventData object itself.
     */
    @Generated
    MediaJobStateChangeEventData setPreviousState(MediaJobState previousState) {
        this.previousState = previousState;
        return this;
    }

    /**
     * Get the state property: The new state of the Job.
     *
     * @return the state value.
     */
    @Generated
    public MediaJobState getState() {
        return this.state;
    }

    /**
     * Set the state property: The new state of the Job.
     *
     * @param state the state value to set.
     * @return the MediaJobStateChangeEventData object itself.
     */
    @Generated
    MediaJobStateChangeEventData setState(MediaJobState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the correlationData property: Gets the Job correlation data.
     *
     * @return the correlationData value.
     */
    @Generated
    public Map<String, String> getCorrelationData() {
        return this.correlationData;
    }

    /**
     * Set the correlationData property: Gets the Job correlation data.
     *
     * @param correlationData the correlationData value to set.
     * @return the MediaJobStateChangeEventData object itself.
     */
    @Generated
    public MediaJobStateChangeEventData setCorrelationData(Map<String, String> correlationData) {
        this.correlationData = correlationData;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("correlationData", this.correlationData,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MediaJobStateChangeEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of MediaJobStateChangeEventData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MediaJobStateChangeEventData.
     */
    @Generated
    public static MediaJobStateChangeEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MediaJobStateChangeEventData deserializedMediaJobStateChangeEventData = new MediaJobStateChangeEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("previousState".equals(fieldName)) {
                    deserializedMediaJobStateChangeEventData.previousState
                        = MediaJobState.fromString(reader.getString());
                } else if ("state".equals(fieldName)) {
                    deserializedMediaJobStateChangeEventData.state = MediaJobState.fromString(reader.getString());
                } else if ("correlationData".equals(fieldName)) {
                    Map<String, String> correlationData = reader.readMap(reader1 -> reader1.getString());
                    deserializedMediaJobStateChangeEventData.correlationData = correlationData;
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedMediaJobStateChangeEventData;
        });
    }
}
