// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for an Microsoft.Storage.BlobInventoryPolicyCompleted event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class StorageBlobInventoryPolicyCompletedEventData
    implements JsonSerializable<StorageBlobInventoryPolicyCompletedEventData> {

    /*
     * The time at which inventory policy was scheduled.
     */
    @Generated
    private OffsetDateTime scheduleDateTime;

    /*
     * The account name for which inventory policy is registered.
     */
    @Generated
    private String accountName;

    /*
     * The rule name for inventory policy.
     */
    @Generated
    private String ruleName;

    /*
     * The status of inventory run, it can be Succeeded/PartiallySucceeded/Failed.
     */
    @Generated
    private String policyRunStatus;

    /*
     * The status message for inventory run.
     */
    @Generated
    private String policyRunStatusMessage;

    /*
     * The policy run id for inventory run.
     */
    @Generated
    private String policyRunId;

    /*
     * The blob URL for manifest file for inventory run.
     */
    @Generated
    private String manifestBlobUrl;

    /**
     * Creates an instance of StorageBlobInventoryPolicyCompletedEventData class.
     */
    @Generated
    public StorageBlobInventoryPolicyCompletedEventData() {
    }

    /**
     * Get the scheduleDateTime property: The time at which inventory policy was scheduled.
     *
     * @return the scheduleDateTime value.
     */
    @Generated
    public OffsetDateTime getScheduleDateTime() {
        return this.scheduleDateTime;
    }

    /**
     * Set the scheduleDateTime property: The time at which inventory policy was scheduled.
     *
     * @param scheduleDateTime the scheduleDateTime value to set.
     * @return the StorageBlobInventoryPolicyCompletedEventData object itself.
     */
    @Generated
    public StorageBlobInventoryPolicyCompletedEventData setScheduleDateTime(OffsetDateTime scheduleDateTime) {
        this.scheduleDateTime = scheduleDateTime;
        return this;
    }

    /**
     * Get the accountName property: The account name for which inventory policy is registered.
     *
     * @return the accountName value.
     */
    @Generated
    public String getAccountName() {
        return this.accountName;
    }

    /**
     * Set the accountName property: The account name for which inventory policy is registered.
     *
     * @param accountName the accountName value to set.
     * @return the StorageBlobInventoryPolicyCompletedEventData object itself.
     */
    @Generated
    public StorageBlobInventoryPolicyCompletedEventData setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get the ruleName property: The rule name for inventory policy.
     *
     * @return the ruleName value.
     */
    @Generated
    public String getRuleName() {
        return this.ruleName;
    }

    /**
     * Set the ruleName property: The rule name for inventory policy.
     *
     * @param ruleName the ruleName value to set.
     * @return the StorageBlobInventoryPolicyCompletedEventData object itself.
     */
    @Generated
    public StorageBlobInventoryPolicyCompletedEventData setRuleName(String ruleName) {
        this.ruleName = ruleName;
        return this;
    }

    /**
     * Get the policyRunStatus property: The status of inventory run, it can be Succeeded/PartiallySucceeded/Failed.
     *
     * @return the policyRunStatus value.
     */
    @Generated
    public String getPolicyRunStatus() {
        return this.policyRunStatus;
    }

    /**
     * Set the policyRunStatus property: The status of inventory run, it can be Succeeded/PartiallySucceeded/Failed.
     *
     * @param policyRunStatus the policyRunStatus value to set.
     * @return the StorageBlobInventoryPolicyCompletedEventData object itself.
     */
    @Generated
    public StorageBlobInventoryPolicyCompletedEventData setPolicyRunStatus(String policyRunStatus) {
        this.policyRunStatus = policyRunStatus;
        return this;
    }

    /**
     * Get the policyRunStatusMessage property: The status message for inventory run.
     *
     * @return the policyRunStatusMessage value.
     */
    @Generated
    public String getPolicyRunStatusMessage() {
        return this.policyRunStatusMessage;
    }

    /**
     * Set the policyRunStatusMessage property: The status message for inventory run.
     *
     * @param policyRunStatusMessage the policyRunStatusMessage value to set.
     * @return the StorageBlobInventoryPolicyCompletedEventData object itself.
     */
    @Generated
    public StorageBlobInventoryPolicyCompletedEventData setPolicyRunStatusMessage(String policyRunStatusMessage) {
        this.policyRunStatusMessage = policyRunStatusMessage;
        return this;
    }

    /**
     * Get the policyRunId property: The policy run id for inventory run.
     *
     * @return the policyRunId value.
     */
    @Generated
    public String getPolicyRunId() {
        return this.policyRunId;
    }

    /**
     * Set the policyRunId property: The policy run id for inventory run.
     *
     * @param policyRunId the policyRunId value to set.
     * @return the StorageBlobInventoryPolicyCompletedEventData object itself.
     */
    @Generated
    public StorageBlobInventoryPolicyCompletedEventData setPolicyRunId(String policyRunId) {
        this.policyRunId = policyRunId;
        return this;
    }

    /**
     * Get the manifestBlobUrl property: The blob URL for manifest file for inventory run.
     *
     * @return the manifestBlobUrl value.
     */
    @Generated
    public String getManifestBlobUrl() {
        return this.manifestBlobUrl;
    }

    /**
     * Set the manifestBlobUrl property: The blob URL for manifest file for inventory run.
     *
     * @param manifestBlobUrl the manifestBlobUrl value to set.
     * @return the StorageBlobInventoryPolicyCompletedEventData object itself.
     */
    @Generated
    public StorageBlobInventoryPolicyCompletedEventData setManifestBlobUrl(String manifestBlobUrl) {
        this.manifestBlobUrl = manifestBlobUrl;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scheduleDateTime",
            this.scheduleDateTime == null
                ? null
                : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.scheduleDateTime));
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("ruleName", this.ruleName);
        jsonWriter.writeStringField("policyRunStatus", this.policyRunStatus);
        jsonWriter.writeStringField("policyRunStatusMessage", this.policyRunStatusMessage);
        jsonWriter.writeStringField("policyRunId", this.policyRunId);
        jsonWriter.writeStringField("manifestBlobUrl", this.manifestBlobUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageBlobInventoryPolicyCompletedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageBlobInventoryPolicyCompletedEventData if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageBlobInventoryPolicyCompletedEventData.
     */
    @Generated
    public static StorageBlobInventoryPolicyCompletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageBlobInventoryPolicyCompletedEventData deserializedStorageBlobInventoryPolicyCompletedEventData
                = new StorageBlobInventoryPolicyCompletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scheduleDateTime".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.scheduleDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("accountName".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.accountName = reader.getString();
                } else if ("ruleName".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.ruleName = reader.getString();
                } else if ("policyRunStatus".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.policyRunStatus = reader.getString();
                } else if ("policyRunStatusMessage".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.policyRunStatusMessage
                        = reader.getString();
                } else if ("policyRunId".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.policyRunId = reader.getString();
                } else if ("manifestBlobUrl".equals(fieldName)) {
                    deserializedStorageBlobInventoryPolicyCompletedEventData.manifestBlobUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedStorageBlobInventoryPolicyCompletedEventData;
        });
    }
}
