// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.eventgrid.systemevents;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Schema of the Data property of an EventGridEvent for an Microsoft.Storage.StorageTaskAssignmentCompleted event.
 * 
 * @deprecated This class is deprecated and may be removed in future releases. System events are now available in the
 * azure-messaging-eventgrid-systemevents package.
 */
@Fluent
@Deprecated
public final class StorageTaskAssignmentCompletedEventData
    implements JsonSerializable<StorageTaskAssignmentCompletedEventData> {

    /*
     * The status for a storage task.
     */
    @Generated
    private StorageTaskAssignmentCompletedStatus status;

    /*
     * The time at which a storage task was completed.
     */
    @Generated
    private OffsetDateTime completedOn;

    /*
     * The execution id for a storage task.
     */
    @Generated
    private String taskExecutionId;

    /*
     * The task name for a storage task.
     */
    @Generated
    private String taskName;

    /*
     * The summary report blob url for a storage task
     */
    @Generated
    private String summaryReportBlobUri;

    /**
     * Creates an instance of StorageTaskAssignmentCompletedEventData class.
     */
    @Generated
    public StorageTaskAssignmentCompletedEventData() {
    }

    /**
     * Get the status property: The status for a storage task.
     *
     * @return the status value.
     */
    @Generated
    public StorageTaskAssignmentCompletedStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: The status for a storage task.
     *
     * @param status the status value to set.
     * @return the StorageTaskAssignmentCompletedEventData object itself.
     */
    @Generated
    public StorageTaskAssignmentCompletedEventData setStatus(StorageTaskAssignmentCompletedStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the completedOn property: The time at which a storage task was completed.
     *
     * @return the completedOn value.
     */
    @Generated
    public OffsetDateTime getCompletedOn() {
        return this.completedOn;
    }

    /**
     * Set the completedOn property: The time at which a storage task was completed.
     *
     * @param completedOn the completedOn value to set.
     * @return the StorageTaskAssignmentCompletedEventData object itself.
     */
    @Generated
    public StorageTaskAssignmentCompletedEventData setCompletedOn(OffsetDateTime completedOn) {
        this.completedOn = completedOn;
        return this;
    }

    /**
     * Get the taskExecutionId property: The execution id for a storage task.
     *
     * @return the taskExecutionId value.
     */
    @Generated
    public String getTaskExecutionId() {
        return this.taskExecutionId;
    }

    /**
     * Set the taskExecutionId property: The execution id for a storage task.
     *
     * @param taskExecutionId the taskExecutionId value to set.
     * @return the StorageTaskAssignmentCompletedEventData object itself.
     */
    @Generated
    public StorageTaskAssignmentCompletedEventData setTaskExecutionId(String taskExecutionId) {
        this.taskExecutionId = taskExecutionId;
        return this;
    }

    /**
     * Get the taskName property: The task name for a storage task.
     *
     * @return the taskName value.
     */
    @Generated
    public String getTaskName() {
        return this.taskName;
    }

    /**
     * Set the taskName property: The task name for a storage task.
     *
     * @param taskName the taskName value to set.
     * @return the StorageTaskAssignmentCompletedEventData object itself.
     */
    @Generated
    public StorageTaskAssignmentCompletedEventData setTaskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    /**
     * Get the summaryReportBlobUri property: The summary report blob url for a storage task.
     *
     * @return the summaryReportBlobUri value.
     */
    @Generated
    public String getSummaryReportBlobUri() {
        return this.summaryReportBlobUri;
    }

    /**
     * Set the summaryReportBlobUri property: The summary report blob url for a storage task.
     *
     * @param summaryReportBlobUri the summaryReportBlobUri value to set.
     * @return the StorageTaskAssignmentCompletedEventData object itself.
     */
    @Generated
    public StorageTaskAssignmentCompletedEventData setSummaryReportBlobUri(String summaryReportBlobUri) {
        this.summaryReportBlobUri = summaryReportBlobUri;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("completedDateTime",
            this.completedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.completedOn));
        jsonWriter.writeStringField("taskExecutionId", this.taskExecutionId);
        jsonWriter.writeStringField("taskName", this.taskName);
        jsonWriter.writeStringField("summaryReportBlobUrl", this.summaryReportBlobUri);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StorageTaskAssignmentCompletedEventData from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of StorageTaskAssignmentCompletedEventData if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StorageTaskAssignmentCompletedEventData.
     */
    @Generated
    public static StorageTaskAssignmentCompletedEventData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StorageTaskAssignmentCompletedEventData deserializedStorageTaskAssignmentCompletedEventData
                = new StorageTaskAssignmentCompletedEventData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedStorageTaskAssignmentCompletedEventData.status
                        = StorageTaskAssignmentCompletedStatus.fromString(reader.getString());
                } else if ("completedDateTime".equals(fieldName)) {
                    deserializedStorageTaskAssignmentCompletedEventData.completedOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("taskExecutionId".equals(fieldName)) {
                    deserializedStorageTaskAssignmentCompletedEventData.taskExecutionId = reader.getString();
                } else if ("taskName".equals(fieldName)) {
                    deserializedStorageTaskAssignmentCompletedEventData.taskName = reader.getString();
                } else if ("summaryReportBlobUrl".equals(fieldName)) {
                    deserializedStorageTaskAssignmentCompletedEventData.summaryReportBlobUri = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedStorageTaskAssignmentCompletedEventData;
        });
    }
}
