/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpMessageConstant;
import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.implementation.AmqpConstants;
import com.azure.core.amqp.implementation.ErrorContextProvider;
import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.ProcessKind;
import com.azure.messaging.eventhubs.EventData;
import java.nio.BufferOverflowException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;
import reactor.core.publisher.Signal;

public final class EventDataBatch {
    private final ClientLogger logger = new ClientLogger(EventDataBatch.class);
    private final Object lock = new Object();
    private final int maxMessageSize;
    private final String partitionKey;
    private final ErrorContextProvider contextProvider;
    private final List<EventData> events;
    private final byte[] eventBytes;
    private final String partitionId;
    private int sizeInBytes;
    private final TracerProvider tracerProvider;
    private final String entityPath;
    private final String hostname;

    EventDataBatch(int maxMessageSize, String partitionId, String partitionKey, ErrorContextProvider contextProvider, TracerProvider tracerProvider, String entityPath, String hostname) {
        this.maxMessageSize = maxMessageSize;
        this.partitionKey = partitionKey;
        this.partitionId = partitionId;
        this.contextProvider = contextProvider;
        this.events = new LinkedList<EventData>();
        this.sizeInBytes = maxMessageSize / 65536 * 1024;
        this.eventBytes = new byte[maxMessageSize];
        this.tracerProvider = tracerProvider;
        this.entityPath = entityPath;
        this.hostname = hostname;
    }

    public int getCount() {
        return this.events.size();
    }

    public int getMaxSizeInBytes() {
        return this.maxMessageSize;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAdd(EventData eventData) {
        int size;
        if (eventData == null) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("eventData cannot be null"));
        }
        EventData event = this.tracerProvider.isEnabled() ? this.traceMessageSpan(eventData) : eventData;
        try {
            size = this.getSize(event, this.events.isEmpty());
        }
        catch (BufferOverflowException exception) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new AmqpException(false, AmqpErrorCondition.LINK_PAYLOAD_SIZE_EXCEEDED, String.format(Locale.US, "Size of the payload exceeded maximum message size: %s kb", this.maxMessageSize / 1024), this.contextProvider.getErrorContext()));
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.sizeInBytes + size > this.maxMessageSize) {
                return false;
            }
            this.sizeInBytes += size;
        }
        this.events.add(event);
        return true;
    }

    private EventData traceMessageSpan(EventData eventData) {
        Optional eventContextData = eventData.getContext().getData((Object)"span-context");
        if (eventContextData.isPresent()) {
            return eventData;
        }
        Context eventContext = eventData.getContext().addData((Object)"az.namespace", (Object)"Microsoft.EventHub").addData((Object)"entity-path", (Object)this.entityPath).addData((Object)"hostname", (Object)this.hostname);
        Context eventSpanContext = this.tracerProvider.startSpan(eventContext, ProcessKind.MESSAGE);
        Optional eventDiagnosticIdOptional = eventSpanContext.getData((Object)"diagnostic-id");
        if (eventDiagnosticIdOptional.isPresent()) {
            eventData.getProperties().put("diagnostic-id", eventDiagnosticIdOptional.get().toString());
            this.tracerProvider.endSpan(eventSpanContext, Signal.complete());
            eventData.addContext("span-context", eventSpanContext);
        }
        return eventData;
    }

    List<EventData> getEvents() {
        return this.events;
    }

    String getPartitionKey() {
        return this.partitionKey;
    }

    String getPartitionId() {
        return this.partitionId;
    }

    private int getSize(EventData eventData, boolean isFirst) {
        Objects.requireNonNull(eventData, "'eventData' cannot be null.");
        Message amqpMessage = this.createAmqpMessage(eventData, this.partitionKey);
        int eventSize = amqpMessage.encode(this.eventBytes, 0, this.maxMessageSize);
        eventSize += 16;
        if (isFirst) {
            amqpMessage.setBody(null);
            amqpMessage.setApplicationProperties(null);
            amqpMessage.setProperties(null);
            amqpMessage.setDeliveryAnnotations(null);
            eventSize += amqpMessage.encode(this.eventBytes, 0, this.maxMessageSize);
        }
        return eventSize;
    }

    private Message createAmqpMessage(EventData event, String partitionKey) {
        Message message = Proton.message();
        if (event.getProperties() != null && !event.getProperties().isEmpty()) {
            ApplicationProperties applicationProperties = new ApplicationProperties(event.getProperties());
            message.setApplicationProperties(applicationProperties);
        }
        if (event.getSystemProperties() != null) {
            event.getSystemProperties().forEach((key, value) -> {
                block17: {
                    block16: {
                        if (EventData.RESERVED_SYSTEM_PROPERTIES.contains(key)) {
                            return;
                        }
                        AmqpMessageConstant constant = AmqpMessageConstant.fromString((String)key);
                        if (constant == null) break block16;
                        switch (constant) {
                            case MESSAGE_ID: {
                                message.setMessageId(value);
                                break block17;
                            }
                            case USER_ID: {
                                message.setUserId((byte[])value);
                                break block17;
                            }
                            case TO: {
                                message.setAddress((String)value);
                                break block17;
                            }
                            case SUBJECT: {
                                message.setSubject((String)value);
                                break block17;
                            }
                            case REPLY_TO: {
                                message.setReplyTo((String)value);
                                break block17;
                            }
                            case CORRELATION_ID: {
                                message.setCorrelationId(value);
                                break block17;
                            }
                            case CONTENT_TYPE: {
                                message.setContentType((String)value);
                                break block17;
                            }
                            case CONTENT_ENCODING: {
                                message.setContentEncoding((String)value);
                                break block17;
                            }
                            case ABSOLUTE_EXPIRY_TIME: {
                                message.setExpiryTime(((Long)value).longValue());
                                break block17;
                            }
                            case CREATION_TIME: {
                                message.setCreationTime(((Long)value).longValue());
                                break block17;
                            }
                            case GROUP_ID: {
                                message.setGroupId((String)value);
                                break block17;
                            }
                            case GROUP_SEQUENCE: {
                                message.setGroupSequence(((Long)value).longValue());
                                break block17;
                            }
                            case REPLY_TO_GROUP_ID: {
                                message.setReplyToGroupId((String)value);
                                break block17;
                            }
                            default: {
                                throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException(String.format(Locale.US, "Property is not a recognized reserved property name: %s", key)));
                            }
                        }
                    }
                    MessageAnnotations messageAnnotations = message.getMessageAnnotations() == null ? new MessageAnnotations(new HashMap()) : message.getMessageAnnotations();
                    messageAnnotations.getValue().put(Symbol.getSymbol((String)key), value);
                    message.setMessageAnnotations(messageAnnotations);
                }
            });
        }
        if (partitionKey != null) {
            MessageAnnotations messageAnnotations = message.getMessageAnnotations() == null ? new MessageAnnotations(new HashMap()) : message.getMessageAnnotations();
            messageAnnotations.getValue().put(AmqpConstants.PARTITION_KEY, partitionKey);
            message.setMessageAnnotations(messageAnnotations);
        }
        message.setBody((Section)new Data(new Binary(event.getBody())));
        return message;
    }
}

