/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpMessageConstant;
import com.azure.core.amqp.models.AmqpAnnotatedMessage;
import com.azure.core.amqp.models.AmqpMessageBody;
import com.azure.core.amqp.models.AmqpMessageId;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.SystemProperties;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class EventData {
    static final Set<String> RESERVED_SYSTEM_PROPERTIES;
    private final Map<String, Object> properties;
    private final SystemProperties systemProperties;
    private final AmqpAnnotatedMessage annotatedMessage;
    private Context context;

    public EventData(byte[] body) {
        this.context = Context.NONE;
        AmqpMessageBody messageBody = AmqpMessageBody.fromData((byte[])Objects.requireNonNull(body, "'body' cannot be null."));
        this.annotatedMessage = new AmqpAnnotatedMessage(messageBody);
        this.properties = this.annotatedMessage.getApplicationProperties();
        this.systemProperties = new SystemProperties();
    }

    public EventData(ByteBuffer body) {
        this(Objects.requireNonNull(body, "'body' cannot be null.").array());
    }

    public EventData(String body) {
        this(Objects.requireNonNull(body, "'body' cannot be null.").getBytes(StandardCharsets.UTF_8));
    }

    public EventData(BinaryData body) {
        this(Objects.requireNonNull(body, "'body' cannot be null.").toBytes());
    }

    EventData(AmqpAnnotatedMessage amqpAnnotatedMessage, SystemProperties systemProperties, Context context) {
        this.context = Objects.requireNonNull(context, "'context' cannot be null.");
        this.properties = Collections.unmodifiableMap(amqpAnnotatedMessage.getApplicationProperties());
        this.annotatedMessage = Objects.requireNonNull(amqpAnnotatedMessage, "'amqpAnnotatedMessage' cannot be null.");
        this.systemProperties = systemProperties;
        switch (this.annotatedMessage.getBody().getBodyType()) {
            case DATA: {
                break;
            }
            case SEQUENCE: 
            case VALUE: {
                new ClientLogger(EventData.class).warning("Message body type '{}' is not supported in EH.  Getting contents of body may throw.", new Object[]{this.annotatedMessage.getBody().getBodyType()});
                break;
            }
            default: {
                throw new ClientLogger(EventData.class).logExceptionAsError((RuntimeException)new IllegalArgumentException("Body type not valid " + this.annotatedMessage.getBody().getBodyType()));
            }
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, Object> getSystemProperties() {
        return this.systemProperties;
    }

    public byte[] getBody() {
        return this.annotatedMessage.getBody().getFirstData();
    }

    public String getBodyAsString() {
        return new String(this.annotatedMessage.getBody().getFirstData(), StandardCharsets.UTF_8);
    }

    public BinaryData getBodyAsBinaryData() {
        return BinaryData.fromBytes((byte[])this.annotatedMessage.getBody().getFirstData());
    }

    public Long getOffset() {
        return this.systemProperties.getOffset();
    }

    public String getPartitionKey() {
        return this.systemProperties.getPartitionKey();
    }

    public Instant getEnqueuedTime() {
        return this.systemProperties.getEnqueuedTime();
    }

    public Long getSequenceNumber() {
        return this.systemProperties.getSequenceNumber();
    }

    public AmqpAnnotatedMessage getRawAmqpMessage() {
        return this.annotatedMessage;
    }

    public String getContentType() {
        return this.annotatedMessage.getProperties().getContentType();
    }

    public EventData setContentType(String contentType) {
        this.annotatedMessage.getProperties().setContentType(contentType);
        return this;
    }

    public String getCorrelationId() {
        AmqpMessageId messageId = this.annotatedMessage.getProperties().getCorrelationId();
        return messageId != null ? messageId.toString() : null;
    }

    public EventData setCorrelationId(String correlationId) {
        AmqpMessageId id = correlationId != null ? new AmqpMessageId(correlationId) : null;
        this.annotatedMessage.getProperties().setCorrelationId(id);
        return this;
    }

    public String getMessageId() {
        AmqpMessageId messageId = this.annotatedMessage.getProperties().getMessageId();
        return messageId != null ? messageId.toString() : null;
    }

    public EventData setMessageId(String messageId) {
        AmqpMessageId id = messageId != null ? new AmqpMessageId(messageId) : null;
        this.annotatedMessage.getProperties().setMessageId(id);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventData eventData = (EventData)o;
        return Arrays.equals(this.annotatedMessage.getBody().getFirstData(), eventData.annotatedMessage.getBody().getFirstData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.annotatedMessage.getBody().getFirstData());
    }

    Context getContext() {
        return this.context;
    }

    public EventData addContext(String key, Object value) {
        Objects.requireNonNull(key, "The 'key' parameter cannot be null.");
        Objects.requireNonNull(value, "The 'value' parameter cannot be null.");
        this.context = this.context.addData((Object)key, value);
        return this;
    }

    static {
        HashSet<String> properties = new HashSet<String>();
        properties.add(AmqpMessageConstant.OFFSET_ANNOTATION_NAME.getValue());
        properties.add(AmqpMessageConstant.PARTITION_KEY_ANNOTATION_NAME.getValue());
        properties.add(AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME.getValue());
        properties.add(AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME.getValue());
        properties.add(AmqpMessageConstant.PUBLISHER_ANNOTATION_NAME.getValue());
        RESERVED_SYSTEM_PROPERTIES = Collections.unmodifiableSet(properties);
    }
}

