/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.util.IterableStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;

public final class EventHubProperties {
    private final String name;
    private final Instant createdAt;
    private final IterableStream<String> partitionIds;

    EventHubProperties(String name, Instant createdAt, String[] partitionIds) {
        this.name = Objects.requireNonNull(name, "'name' cannot be null.");
        this.createdAt = Objects.requireNonNull(createdAt, "'createdAt' cannot be null.");
        this.partitionIds = new IterableStream(Arrays.asList(Objects.requireNonNull(partitionIds, "'partitionIds' cannot be null.")));
    }

    public String getName() {
        return this.name;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public IterableStream<String> getPartitionIds() {
        return this.partitionIds;
    }
}

