/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.models;

import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.Checkpoint;
import com.azure.messaging.eventhubs.models.LastEnqueuedEventProperties;
import com.azure.messaging.eventhubs.models.PartitionContext;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class EventContext {
    private final PartitionContext partitionContext;
    private final EventData eventData;
    private final CheckpointStore checkpointStore;
    private final LastEnqueuedEventProperties lastEnqueuedEventProperties;

    public EventContext(PartitionContext partitionContext, EventData eventData, CheckpointStore checkpointStore, LastEnqueuedEventProperties lastEnqueuedEventProperties) {
        this.partitionContext = Objects.requireNonNull(partitionContext, "'partitionContext' cannot be null.");
        this.eventData = eventData;
        this.checkpointStore = Objects.requireNonNull(checkpointStore, "'checkpointStore' cannot be null.");
        this.lastEnqueuedEventProperties = lastEnqueuedEventProperties;
    }

    public PartitionContext getPartitionContext() {
        return this.partitionContext;
    }

    public EventData getEventData() {
        return this.eventData;
    }

    public LastEnqueuedEventProperties getLastEnqueuedEventProperties() {
        return this.lastEnqueuedEventProperties;
    }

    public Mono<Void> updateCheckpointAsync() {
        if (this.eventData == null) {
            return Mono.empty();
        }
        Checkpoint checkpoint = new Checkpoint().setFullyQualifiedNamespace(this.partitionContext.getFullyQualifiedNamespace()).setEventHubName(this.partitionContext.getEventHubName()).setConsumerGroup(this.partitionContext.getConsumerGroup()).setPartitionId(this.partitionContext.getPartitionId()).setSequenceNumber(this.eventData.getSequenceNumber()).setOffset(this.eventData.getOffset());
        return this.checkpointStore.updateCheckpoint(checkpoint);
    }

    public void updateCheckpoint() {
        this.updateCheckpointAsync().block();
    }
}

