/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation;

import com.azure.core.util.logging.ClientLogger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.time.Duration;
import reactor.core.publisher.Flux;

public final class ReactorShim {
    private static final ClientLogger LOGGER = new ClientLogger(ReactorShim.class);
    private static final String WINDOW_TIMEOUT_OPERATOR = "windowTimeout";
    private static final MethodHandle BACKPRESSURE_WINDOW_TIMEOUT_OPERATOR_HANDLE = ReactorShim.lookupBackpressureWindowTimeoutOperator();

    public static <T> Flux<Flux<T>> windowTimeout(Flux<T> source, int maxSize, Duration maxTime) {
        if (BACKPRESSURE_WINDOW_TIMEOUT_OPERATOR_HANDLE == null) {
            return source.windowTimeout(maxSize, maxTime);
        }
        try {
            return BACKPRESSURE_WINDOW_TIMEOUT_OPERATOR_HANDLE.invoke(source, maxSize, maxTime, true);
        }
        catch (Throwable err) {
            if (err instanceof Error) {
                throw (Error)err;
            }
            if (err instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)err);
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(err));
        }
    }

    private static MethodHandle lookupBackpressureWindowTimeoutOperator() {
        try {
            return MethodHandles.publicLookup().findVirtual(Flux.class, WINDOW_TIMEOUT_OPERATOR, MethodType.methodType(Flux.class, Integer.TYPE, Duration.class, Boolean.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException err) {
            LOGGER.verbose("Failed to retrieve MethodHandle for backpressure aware windowTimeout Reactor operator.", new Object[]{err});
            return null;
        }
    }
}

