/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation.instrumentation;

import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.ProcessKind;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.models.PartitionEvent;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.qpid.proton.message.Message;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class EventHubsTracer {
    private static final AutoCloseable NOOP_AUTOCLOSEABLE = () -> {};
    public static final String REACTOR_PARENT_TRACE_CONTEXT_KEY = "otel-context-key";
    public static final String TRACEPARENT_KEY = "traceparent";
    private static final ClientLogger LOGGER = new ClientLogger(EventHubsTracer.class);
    private static final boolean IS_TRACING_DISABLED = (Boolean)Configuration.getGlobalConfiguration().get("AZURE_TRACING_DISABLED", (Object)false);
    protected final Tracer tracer;
    private final String fullyQualifiedName;
    private final String entityName;

    public EventHubsTracer(Tracer tracer, String fullyQualifiedName, String entityName) {
        this.tracer = IS_TRACING_DISABLED ? null : tracer;
        this.fullyQualifiedName = Objects.requireNonNull(fullyQualifiedName, "'fullyQualifiedName' cannot be null");
        this.entityName = Objects.requireNonNull(entityName, "'entityPath' cannot be null");
    }

    public static Tracer getDefaultTracer() {
        ServiceLoader<Tracer> tracers = ServiceLoader.load(Tracer.class);
        Iterator it = tracers.iterator();
        return it.hasNext() ? (Tracer)it.next() : null;
    }

    public boolean isEnabled() {
        return this.tracer != null;
    }

    public com.azure.core.util.Context startSpan(String spanName, com.azure.core.util.Context context, ProcessKind kind) {
        return this.tracer == null ? context : this.tracer.start(spanName, context, kind);
    }

    public <T> Mono<T> traceMono(Mono<T> publisher, String spanName) {
        if (this.tracer != null) {
            return publisher.doOnEach(signal -> {
                if (signal.isOnComplete() || signal.isOnError()) {
                    com.azure.core.util.Context span = (com.azure.core.util.Context)signal.getContextView().getOrDefault((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)com.azure.core.util.Context.NONE);
                    this.endSpan(signal.getThrowable(), span, null);
                }
            }).contextWrite((ContextView)Context.of((Object)REACTOR_PARENT_TRACE_CONTEXT_KEY, (Object)this.tracer.start(spanName, this.setAttributes(com.azure.core.util.Context.NONE), ProcessKind.SEND)));
        }
        return publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSpan(Throwable throwable, com.azure.core.util.Context span, AutoCloseable scope) {
        if (this.tracer != null) {
            String errorCondition = "success";
            if (throwable instanceof AmqpException) {
                AmqpException exception = (AmqpException)throwable;
                errorCondition = exception.getErrorCondition().getErrorCondition();
            }
            try {
                if (scope != null) {
                    scope.close();
                }
            }
            catch (Exception e) {
                LOGGER.warning("Can't close scope", new Object[]{e});
            }
            finally {
                this.tracer.end(errorCondition, throwable, span);
            }
        }
    }

    public void reportMessageSpan(EventData eventData, com.azure.core.util.Context eventContext) {
        if (this.tracer == null || eventContext == null || eventContext.getData((Object)"span-context").isPresent()) {
            return;
        }
        String traceparent = EventHubsTracer.getTraceparent(eventData.getProperties());
        if (traceparent != null) {
            return;
        }
        com.azure.core.util.Context newMessageContext = this.setAttributes(eventContext);
        com.azure.core.util.Context eventSpanContext = this.tracer.start("EventHubs.message", newMessageContext, ProcessKind.MESSAGE);
        Optional traceparentOpt = eventSpanContext.getData((Object)"Diagnostic-Id");
        if (traceparentOpt.isPresent()) {
            eventData.getProperties().put("Diagnostic-Id", traceparentOpt.get().toString());
            eventData.getProperties().put(TRACEPARENT_KEY, traceparentOpt.get().toString());
            this.endSpan(null, eventSpanContext, null);
            Optional spanContext = eventSpanContext.getData((Object)"span-context");
            if (spanContext.isPresent()) {
                eventData.addContext("span-context", spanContext.get());
            }
        }
    }

    public com.azure.core.util.Context getBuilder(String spanName, com.azure.core.util.Context context) {
        return this.tracer == null ? context : this.setAttributes(this.tracer.getSharedSpanBuilder(spanName, context));
    }

    public void addLink(Map<String, Object> applicationProperties, Instant enqueuedTime, com.azure.core.util.Context spanBuilder, com.azure.core.util.Context eventContext) {
        if (this.tracer != null) {
            Optional linkContext = eventContext.getData((Object)"span-context");
            if (!linkContext.isPresent()) {
                String traceparent = EventHubsTracer.getTraceparent(applicationProperties);
                com.azure.core.util.Context link = traceparent == null ? com.azure.core.util.Context.NONE : this.tracer.extractContext(traceparent, com.azure.core.util.Context.NONE);
                linkContext = link.getData((Object)"span-context");
            }
            if (enqueuedTime != null) {
                spanBuilder = spanBuilder.addData((Object)"x-opt-enqueued-time", (Object)enqueuedTime.atOffset(ZoneOffset.UTC).toEpochSecond());
            }
            if (linkContext.isPresent()) {
                this.tracer.addLink(spanBuilder.addData((Object)"span-context", linkContext.get()));
            }
        }
    }

    public AutoCloseable makeSpanCurrent(com.azure.core.util.Context context) {
        return this.tracer == null ? NOOP_AUTOCLOSEABLE : this.tracer.makeSpanCurrent(context);
    }

    public com.azure.core.util.Context setParentAndAttributes(Message message, Instant enqueuedTime, com.azure.core.util.Context context) {
        if (this.tracer != null) {
            if (enqueuedTime != null) {
                context = context.addData((Object)"x-opt-enqueued-time", (Object)enqueuedTime.atOffset(ZoneOffset.UTC).toEpochSecond());
            }
            if (message.getApplicationProperties() != null) {
                context = this.getParent(message.getApplicationProperties().getValue(), context);
            }
            return this.setAttributes(context);
        }
        return context;
    }

    public com.azure.core.util.Context startProcessSpan(String name, EventData event, com.azure.core.util.Context parent) {
        if (this.tracer != null) {
            com.azure.core.util.Context context = parent;
            Instant enqueuedTime = event.getEnqueuedTime();
            if (enqueuedTime != null) {
                context = parent.addData((Object)"x-opt-enqueued-time", (Object)enqueuedTime.atOffset(ZoneOffset.UTC).toEpochSecond());
            }
            context = this.getParent(event.getProperties(), context);
            return this.tracer.start(name, this.setAttributes(context), ProcessKind.PROCESS);
        }
        return parent;
    }

    public com.azure.core.util.Context startProcessSpan(String name, List<EventData> events, com.azure.core.util.Context parent) {
        if (this.tracer != null) {
            com.azure.core.util.Context context = parent.addData((Object)"span-kind", (Object)SpanKind.CONSUMER);
            com.azure.core.util.Context spanBuilder = this.getBuilder(name, this.setAttributes(context));
            if (events != null) {
                for (EventData event : events) {
                    this.addLink(event.getProperties(), event.getEnqueuedTime(), spanBuilder, com.azure.core.util.Context.NONE);
                }
            }
            return this.tracer.start(name, spanBuilder, ProcessKind.PROCESS);
        }
        return parent;
    }

    public Flux<PartitionEvent> reportSyncReceiveSpan(String name, Instant startTime, Flux<PartitionEvent> events, com.azure.core.util.Context parent) {
        if (this.tracer != null) {
            ArrayList eventsList = new ArrayList();
            return events.doOnEach(signal -> {
                if (signal.isOnNext()) {
                    eventsList.add((PartitionEvent)signal.get());
                } else if (signal.isOnComplete()) {
                    com.azure.core.util.Context spanBuilder = this.getBuilder(name, this.setAttributes(parent.addData((Object)"span-start-time", (Object)startTime)));
                    for (PartitionEvent event : eventsList) {
                        this.addLink(event.getData().getProperties(), event.getData().getEnqueuedTime(), spanBuilder, com.azure.core.util.Context.NONE);
                    }
                    com.azure.core.util.Context span = this.tracer.start(name, spanBuilder, ProcessKind.SEND);
                    this.endSpan(null, span, null);
                }
            });
        }
        return events;
    }

    private static String getTraceparent(Map<String, Object> applicationProperties) {
        Object diagnosticId = applicationProperties.get("Diagnostic-Id");
        if (diagnosticId == null) {
            diagnosticId = applicationProperties.get(TRACEPARENT_KEY);
        }
        return diagnosticId == null ? null : diagnosticId.toString();
    }

    private com.azure.core.util.Context getParent(Map<String, Object> properties, com.azure.core.util.Context context) {
        if (properties == null) {
            return context;
        }
        String traceparent = EventHubsTracer.getTraceparent(properties);
        return traceparent == null ? context : this.tracer.extractContext(traceparent, context);
    }

    private com.azure.core.util.Context setAttributes(com.azure.core.util.Context context) {
        return context.addData((Object)"entity-path", (Object)this.entityName).addData((Object)"hostname", (Object)this.fullyQualifiedName).addData((Object)"az.namespace", (Object)"Microsoft.EventHub");
    }
}

